/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.haiti.core.service;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.sadtech.haiti.context.repository.simple.MultipleOperation;
import org.sadtech.haiti.context.service.simple.MultipleService;
import org.sadtech.haiti.context.service.simple.SimpleService;

public abstract class AbstractMultipleService<T, K>
implements MultipleService<T, K> {
    private final SimpleService<T, K> simpleService;
    private final MultipleOperation<T, K> multipleOperation;

    public void deleteAllById(@NonNull Collection<K> ids) {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        this.multipleOperation.deleteAllById(ids);
    }

    public List<T> createAll(@NonNull Collection<T> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        return entities.stream().map(arg_0 -> this.simpleService.create(arg_0)).collect(Collectors.toList());
    }

    public List<T> updateAll(@NonNull Collection<T> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        return entities.stream().map(arg_0 -> this.simpleService.update(arg_0)).collect(Collectors.toList());
    }

    public AbstractMultipleService(SimpleService<T, K> simpleService, MultipleOperation<T, K> multipleOperation) {
        this.simpleService = simpleService;
        this.multipleOperation = multipleOperation;
    }
}

