/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.haiti.core.service;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.sadtech.haiti.context.page.Pagination;
import org.sadtech.haiti.context.page.Sheet;
import org.sadtech.haiti.context.repository.SimpleManagerRepository;
import org.sadtech.haiti.context.service.SimpleManagerService;
import org.sadtech.haiti.core.util.ServiceOperation;

public abstract class AbstractSimpleManagerService<T, K>
implements SimpleManagerService<T, K> {
    private final SimpleManagerRepository<T, K> repository;

    public void deleteAllById(@NonNull Collection<K> primaryKeys) {
        if (primaryKeys == null) {
            throw new NullPointerException("primaryKeys is marked non-null but is null");
        }
        ServiceOperation.deleteAllById(this.repository, primaryKeys);
    }

    public Sheet<T> getAll(@NonNull Pagination pagination) {
        if (pagination == null) {
            throw new NullPointerException("pagination is marked non-null but is null");
        }
        return ServiceOperation.getAll(this.repository, pagination);
    }

    public Optional<T> getById(@NonNull K primaryKey) {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        return ServiceOperation.getById(this.repository, primaryKey);
    }

    public boolean existsById(@NonNull K primaryKey) {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        return ServiceOperation.existsById(this.repository, primaryKey);
    }

    public void deleteById(@NonNull K primaryKey) {
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey is marked non-null but is null");
        }
        ServiceOperation.deleteById(this.repository, primaryKey);
    }

    public List<T> createAll(@NonNull Collection<T> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        return entities.stream().map(arg_0 -> ((AbstractSimpleManagerService)this).create(arg_0)).collect(Collectors.toList());
    }

    public List<T> updateAll(@NonNull Collection<T> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        return entities.stream().map(arg_0 -> ((AbstractSimpleManagerService)this).update(arg_0)).collect(Collectors.toList());
    }

    public AbstractSimpleManagerService(SimpleManagerRepository<T, K> repository) {
        this.repository = repository;
    }
}

