/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.sadtech.autoresponder.AutoResponder;
import org.sadtech.autoresponder.entity.Unit;
import org.sadtech.autoresponder.entity.UnitPointer;
import org.sadtech.autoresponder.repository.UnitPointerRepository;
import org.sadtech.autoresponder.service.UnitPointerService;
import org.sadtech.autoresponder.service.UnitPointerServiceImpl;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.domain.unit.UnitActiveType;
import org.sadtech.social.bot.service.action.ActionUnit;
import org.sadtech.social.bot.service.action.AnswerAccountAction;
import org.sadtech.social.bot.service.action.AnswerCheckAction;
import org.sadtech.social.bot.service.action.AnswerProcessingAction;
import org.sadtech.social.bot.service.action.AnswerSaveAction;
import org.sadtech.social.bot.service.action.AnswerTextAction;
import org.sadtech.social.bot.service.action.AnswerTimerAction;
import org.sadtech.social.bot.service.action.AnswerValidityAction;
import org.sadtech.social.bot.service.timer.TimerService;
import org.sadtech.social.core.domain.content.Message;
import org.sadtech.social.core.exception.ConfigAppException;
import org.sadtech.social.core.exception.NotFoundException;
import org.sadtech.social.core.service.AccountService;
import org.sadtech.social.core.service.MessageService;
import org.sadtech.social.core.service.Modifiable;
import org.sadtech.social.core.service.sender.Sending;

public class GeneralAutoResponder<T extends Message>
extends TimerTask {
    private final MessageService<T> messageService;
    protected final AutoResponder<MainUnit> autoResponder;
    protected Map<String, ActionUnit<? extends MainUnit, ? extends Message>> actionUnitMap = new HashMap<String, ActionUnit<? extends MainUnit, ? extends Message>>();
    protected List<Modifiable<T>> modifiables;
    private ExecutorService executorService = Executors.newFixedThreadPool(10);

    protected GeneralAutoResponder(Set<MainUnit> menuUnit, Sending sending, MessageService<T> messageService, UnitPointerRepository<MainUnit> unitPointerRepository) {
        this.messageService = messageService;
        this.autoResponder = new AutoResponder((UnitPointerService)new UnitPointerServiceImpl(unitPointerRepository), menuUnit);
        this.init(sending);
    }

    private void init(Sending sending) {
        this.actionUnitMap.put("CHECK", new AnswerCheckAction());
        this.actionUnitMap.put("PROCESSING", new AnswerProcessingAction(sending));
        this.actionUnitMap.put("TEXT", new AnswerTextAction(sending));
        this.actionUnitMap.put("VALIDITY", new AnswerValidityAction());
    }

    public void initModifiables(List<Modifiable<T>> modifiables) {
        this.modifiables = modifiables;
    }

    protected void initActionUnit(String typeUnit, ActionUnit<? super MainUnit, T> actionUnit) {
        if (this.actionUnitMap.containsKey(typeUnit)) {
            throw new ConfigAppException("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0442\u0430\u043a\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u044e\u043d\u0438\u0442\u0430 \u0443\u0436\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0430");
        }
        this.actionUnitMap.put(typeUnit, actionUnit);
    }

    public <U extends MainUnit> void initDefaultUnit(U defaultUnit) {
        this.autoResponder.setDefaultUnit(defaultUnit);
    }

    public void initSaveAction(AnswerSaveAction<?> answerSaveAction) {
        this.actionUnitMap.put("SAVE", answerSaveAction);
    }

    public void initTimerAction(TimerService timerService) {
        this.actionUnitMap.put("TIMER", new AnswerTimerAction(timerService, this));
    }

    public void initAccountAction(AccountService accountService, TimerService timerService) {
        this.actionUnitMap.put("ACCOUNT", new AnswerAccountAction(accountService, timerService));
    }

    public void setDefaultUnit(MainUnit mainUnit) {
        this.autoResponder.setDefaultUnit((Unit)mainUnit);
    }

    public void checkNewMessage() {
        List eventByTime = this.messageService.getNewMessage();
        if (eventByTime != null && !eventByTime.isEmpty()) {
            this.executorService.execute(() -> eventByTime.parallelStream().forEach(this.processing()));
        }
    }

    private Consumer<T> processing() {
        return event -> {
            if (this.modifiables != null) {
                this.modifiables.forEach(modifiable -> modifiable.change(event));
            }
            this.autoResponder.answer(event.getPersonId(), event.getText()).ifPresent(unitAnswer -> this.answer((T)event, (MainUnit)((Object)((Object)unitAnswer))));
        };
    }

    public void answer(T event, MainUnit unitAnswer) {
        unitAnswer = this.getAction(event, unitAnswer);
        unitAnswer = this.activeUnitAfter(unitAnswer, event);
        if (this.autoResponder.getDefaultUnit() == null || !((MainUnit)this.autoResponder.getDefaultUnit()).equals((Object)unitAnswer)) {
            this.autoResponder.getUnitPointerService().save(new UnitPointer(event.getPersonId(), (Unit)unitAnswer));
        }
    }

    private MainUnit activeUnitAfter(MainUnit mainUnit, T content) {
        Optional<MainUnit> first;
        if (mainUnit.getNextUnits() != null && (first = mainUnit.getNextUnits().stream().filter(unit -> UnitActiveType.AFTER.equals((Object)unit.getActiveType())).findFirst()).isPresent()) {
            this.getAction(content, first.get());
            return this.activeUnitAfter(first.get(), content);
        }
        return mainUnit;
    }

    private MainUnit getAction(T event, MainUnit unitAnswer) {
        if (this.actionUnitMap.containsKey(unitAnswer.getType())) {
            ActionUnit<? extends MainUnit, ? extends Message> actionUnit = this.actionUnitMap.get(unitAnswer.getType());
            MainUnit mainUnit = actionUnit.action(unitAnswer, (Message)event);
            if (!unitAnswer.equals((Object)mainUnit)) {
                return this.getAction(event, mainUnit);
            }
            return mainUnit;
        }
        throw new NotFoundException("ActionUnit \u0434\u043b\u044f \u0442\u0438\u043f\u0430 " + unitAnswer.getType() + " \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d");
    }

    @Override
    public void run() {
        this.checkNewMessage();
    }
}

