/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.domain.question;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sadtech.social.bot.domain.question.QuestionAnswer;
import org.sadtech.social.core.domain.BoxAnswer;

public class Question {
    private BoxAnswer boxAnswer;
    private List<QuestionAnswer> questionAnswers;

    Question(BoxAnswer boxAnswer, List<QuestionAnswer> questionAnswers) {
        this.boxAnswer = boxAnswer;
        this.questionAnswers = questionAnswers;
    }

    public static QuestionBuilder builder() {
        return new QuestionBuilder();
    }

    public BoxAnswer getBoxAnswer() {
        return this.boxAnswer;
    }

    public List<QuestionAnswer> getQuestionAnswers() {
        return this.questionAnswers;
    }

    public void setBoxAnswer(BoxAnswer boxAnswer) {
        this.boxAnswer = boxAnswer;
    }

    public void setQuestionAnswers(List<QuestionAnswer> questionAnswers) {
        this.questionAnswers = questionAnswers;
    }

    public static class QuestionBuilder {
        private BoxAnswer boxAnswer;
        private ArrayList<QuestionAnswer> questionAnswers;

        QuestionBuilder() {
        }

        public QuestionBuilder boxAnswer(BoxAnswer boxAnswer) {
            this.boxAnswer = boxAnswer;
            return this;
        }

        public QuestionBuilder questionAnswer(QuestionAnswer questionAnswer) {
            if (this.questionAnswers == null) {
                this.questionAnswers = new ArrayList();
            }
            this.questionAnswers.add(questionAnswer);
            return this;
        }

        public QuestionBuilder questionAnswers(Collection<? extends QuestionAnswer> questionAnswers) {
            if (this.questionAnswers == null) {
                this.questionAnswers = new ArrayList();
            }
            this.questionAnswers.addAll(questionAnswers);
            return this;
        }

        public QuestionBuilder clearQuestionAnswers() {
            if (this.questionAnswers != null) {
                this.questionAnswers.clear();
            }
            return this;
        }

        public Question build() {
            List<QuestionAnswer> questionAnswers;
            switch (this.questionAnswers == null ? 0 : this.questionAnswers.size()) {
                case 0: {
                    questionAnswers = Collections.emptyList();
                    break;
                }
                case 1: {
                    questionAnswers = Collections.singletonList(this.questionAnswers.get(0));
                    break;
                }
                default: {
                    questionAnswers = Collections.unmodifiableList(new ArrayList<QuestionAnswer>(this.questionAnswers));
                }
            }
            return new Question(this.boxAnswer, questionAnswers);
        }

        public String toString() {
            return "Question.QuestionBuilder(boxAnswer=" + this.boxAnswer + ", questionAnswers=" + this.questionAnswers + ")";
        }
    }
}

