/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.domain.unit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sadtech.social.bot.domain.AccountAutoCheck;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.domain.unit.UnitActiveType;

public class AnswerAccount
extends MainUnit {
    private final Integer totalSum;
    private final Integer timeHours;
    private final AccountAutoCheck autoCheck;

    private AnswerAccount(Set<String> keyWords, String phrase, Pattern pattern, Integer matchThreshold, Integer priority, Set<MainUnit> nextUnits, UnitActiveType activeType, Integer totalSum, Integer timeHours, AccountAutoCheck autoCheck) {
        super(keyWords, phrase, pattern, matchThreshold, priority, nextUnits, activeType == null ? UnitActiveType.AFTER : activeType, "ACCOUNT");
        this.totalSum = totalSum;
        this.timeHours = timeHours;
        this.autoCheck = autoCheck;
    }

    public static AnswerAccountBuilder builder() {
        return new AnswerAccountBuilder();
    }

    public Integer getTotalSum() {
        return this.totalSum;
    }

    public Integer getTimeHours() {
        return this.timeHours;
    }

    public AccountAutoCheck getAutoCheck() {
        return this.autoCheck;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerAccount)) {
            return false;
        }
        AnswerAccount other = (AnswerAccount)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$totalSum = this.getTotalSum();
        Integer other$totalSum = other.getTotalSum();
        if (this$totalSum == null ? other$totalSum != null : !((Object)this$totalSum).equals(other$totalSum)) {
            return false;
        }
        Integer this$timeHours = this.getTimeHours();
        Integer other$timeHours = other.getTimeHours();
        if (this$timeHours == null ? other$timeHours != null : !((Object)this$timeHours).equals(other$timeHours)) {
            return false;
        }
        AccountAutoCheck this$autoCheck = this.getAutoCheck();
        AccountAutoCheck other$autoCheck = other.getAutoCheck();
        return !(this$autoCheck == null ? other$autoCheck != null : !((Object)this$autoCheck).equals(other$autoCheck));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnswerAccount;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $totalSum = this.getTotalSum();
        result = result * 59 + ($totalSum == null ? 43 : ((Object)$totalSum).hashCode());
        Integer $timeHours = this.getTimeHours();
        result = result * 59 + ($timeHours == null ? 43 : ((Object)$timeHours).hashCode());
        AccountAutoCheck $autoCheck = this.getAutoCheck();
        result = result * 59 + ($autoCheck == null ? 43 : ((Object)$autoCheck).hashCode());
        return result;
    }

    public static class AnswerAccountBuilder {
        private ArrayList<String> keyWords;
        private String phrase;
        private Pattern pattern;
        private Integer matchThreshold;
        private Integer priority;
        private ArrayList<MainUnit> nextUnits;
        private UnitActiveType activeType;
        private Integer totalSum;
        private Integer timeHours;
        private AccountAutoCheck autoCheck;

        AnswerAccountBuilder() {
        }

        public AnswerAccountBuilder keyWord(String keyWord) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.add(keyWord);
            return this;
        }

        public AnswerAccountBuilder keyWords(Collection<? extends String> keyWords) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.addAll(keyWords);
            return this;
        }

        public AnswerAccountBuilder clearKeyWords() {
            if (this.keyWords != null) {
                this.keyWords.clear();
            }
            return this;
        }

        public AnswerAccountBuilder phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public AnswerAccountBuilder pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public AnswerAccountBuilder matchThreshold(Integer matchThreshold) {
            this.matchThreshold = matchThreshold;
            return this;
        }

        public AnswerAccountBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public AnswerAccountBuilder nextUnit(MainUnit nextUnit) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.add(nextUnit);
            return this;
        }

        public AnswerAccountBuilder nextUnits(Collection<? extends MainUnit> nextUnits) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.addAll(nextUnits);
            return this;
        }

        public AnswerAccountBuilder clearNextUnits() {
            if (this.nextUnits != null) {
                this.nextUnits.clear();
            }
            return this;
        }

        public AnswerAccountBuilder activeType(UnitActiveType activeType) {
            this.activeType = activeType;
            return this;
        }

        public AnswerAccountBuilder totalSum(Integer totalSum) {
            this.totalSum = totalSum;
            return this;
        }

        public AnswerAccountBuilder timeHours(Integer timeHours) {
            this.timeHours = timeHours;
            return this;
        }

        public AnswerAccountBuilder autoCheck(AccountAutoCheck autoCheck) {
            this.autoCheck = autoCheck;
            return this;
        }

        public AnswerAccount build() {
            Set<Object> nextUnits;
            Set<Object> keyWords;
            switch (this.keyWords == null ? 0 : this.keyWords.size()) {
                case 0: {
                    keyWords = Collections.emptySet();
                    break;
                }
                case 1: {
                    keyWords = Collections.singleton(this.keyWords.get(0));
                    break;
                }
                default: {
                    keyWords = new LinkedHashSet(this.keyWords.size() < 0x40000000 ? 1 + this.keyWords.size() + (this.keyWords.size() - 3) / 3 : Integer.MAX_VALUE);
                    keyWords.addAll(this.keyWords);
                    keyWords = Collections.unmodifiableSet(keyWords);
                }
            }
            switch (this.nextUnits == null ? 0 : this.nextUnits.size()) {
                case 0: {
                    nextUnits = Collections.emptySet();
                    break;
                }
                case 1: {
                    nextUnits = Collections.singleton(this.nextUnits.get(0));
                    break;
                }
                default: {
                    nextUnits = new LinkedHashSet(this.nextUnits.size() < 0x40000000 ? 1 + this.nextUnits.size() + (this.nextUnits.size() - 3) / 3 : Integer.MAX_VALUE);
                    nextUnits.addAll(this.nextUnits);
                    nextUnits = Collections.unmodifiableSet(nextUnits);
                }
            }
            return new AnswerAccount(keyWords, this.phrase, this.pattern, this.matchThreshold, this.priority, nextUnits, this.activeType, this.totalSum, this.timeHours, this.autoCheck);
        }

        public String toString() {
            return "AnswerAccount.AnswerAccountBuilder(keyWords=" + this.keyWords + ", phrase=" + this.phrase + ", pattern=" + this.pattern + ", matchThreshold=" + this.matchThreshold + ", priority=" + this.priority + ", nextUnits=" + this.nextUnits + ", activeType=" + (Object)((Object)this.activeType) + ", totalSum=" + this.totalSum + ", timeHours=" + this.timeHours + ", autoCheck=" + this.autoCheck + ")";
        }
    }
}

