/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.domain.unit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.domain.unit.UnitActiveType;
import org.sadtech.social.bot.service.usercode.CheckData;
import org.sadtech.social.core.domain.content.Message;

public class AnswerCheck
extends MainUnit {
    private final MainUnit unitTrue;
    private final MainUnit unitFalse;
    private final CheckData<Message> check;

    protected AnswerCheck(Set<String> keyWords, String phrase, Pattern pattern, Integer matchThreshold, Integer priority, Set<MainUnit> nextUnits, UnitActiveType activeType, MainUnit unitTrue, MainUnit unitFalse, CheckData<Message> check) {
        super(keyWords, phrase, pattern, matchThreshold, priority, nextUnits, activeType, "CHECK");
        this.unitTrue = unitTrue;
        this.unitFalse = unitFalse;
        this.check = check;
    }

    public static AnswerCheckBuilder builder() {
        return new AnswerCheckBuilder();
    }

    public MainUnit getUnitTrue() {
        return this.unitTrue;
    }

    public MainUnit getUnitFalse() {
        return this.unitFalse;
    }

    public CheckData<Message> getCheck() {
        return this.check;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerCheck)) {
            return false;
        }
        AnswerCheck other = (AnswerCheck)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MainUnit this$unitTrue = this.getUnitTrue();
        MainUnit other$unitTrue = other.getUnitTrue();
        if (this$unitTrue == null ? other$unitTrue != null : !((Object)((Object)this$unitTrue)).equals((Object)other$unitTrue)) {
            return false;
        }
        MainUnit this$unitFalse = this.getUnitFalse();
        MainUnit other$unitFalse = other.getUnitFalse();
        if (this$unitFalse == null ? other$unitFalse != null : !((Object)((Object)this$unitFalse)).equals((Object)other$unitFalse)) {
            return false;
        }
        CheckData<Message> this$check = this.getCheck();
        CheckData<Message> other$check = other.getCheck();
        return !(this$check == null ? other$check != null : !this$check.equals(other$check));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnswerCheck;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MainUnit $unitTrue = this.getUnitTrue();
        result = result * 59 + ($unitTrue == null ? 43 : ((Object)((Object)$unitTrue)).hashCode());
        MainUnit $unitFalse = this.getUnitFalse();
        result = result * 59 + ($unitFalse == null ? 43 : ((Object)((Object)$unitFalse)).hashCode());
        CheckData<Message> $check = this.getCheck();
        result = result * 59 + ($check == null ? 43 : $check.hashCode());
        return result;
    }

    public static class AnswerCheckBuilder {
        private ArrayList<String> keyWords;
        private String phrase;
        private Pattern pattern;
        private Integer matchThreshold;
        private Integer priority;
        private ArrayList<MainUnit> nextUnits;
        private UnitActiveType activeType;
        private MainUnit unitTrue;
        private MainUnit unitFalse;
        private CheckData<Message> check;

        AnswerCheckBuilder() {
        }

        public AnswerCheckBuilder keyWord(String keyWord) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.add(keyWord);
            return this;
        }

        public AnswerCheckBuilder keyWords(Collection<? extends String> keyWords) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.addAll(keyWords);
            return this;
        }

        public AnswerCheckBuilder clearKeyWords() {
            if (this.keyWords != null) {
                this.keyWords.clear();
            }
            return this;
        }

        public AnswerCheckBuilder phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public AnswerCheckBuilder pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public AnswerCheckBuilder matchThreshold(Integer matchThreshold) {
            this.matchThreshold = matchThreshold;
            return this;
        }

        public AnswerCheckBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public AnswerCheckBuilder nextUnit(MainUnit nextUnit) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.add(nextUnit);
            return this;
        }

        public AnswerCheckBuilder nextUnits(Collection<? extends MainUnit> nextUnits) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.addAll(nextUnits);
            return this;
        }

        public AnswerCheckBuilder clearNextUnits() {
            if (this.nextUnits != null) {
                this.nextUnits.clear();
            }
            return this;
        }

        public AnswerCheckBuilder activeType(UnitActiveType activeType) {
            this.activeType = activeType;
            return this;
        }

        public AnswerCheckBuilder unitTrue(MainUnit unitTrue) {
            this.unitTrue = unitTrue;
            return this;
        }

        public AnswerCheckBuilder unitFalse(MainUnit unitFalse) {
            this.unitFalse = unitFalse;
            return this;
        }

        public AnswerCheckBuilder check(CheckData<Message> check) {
            this.check = check;
            return this;
        }

        public AnswerCheck build() {
            Set<Object> nextUnits;
            Set<Object> keyWords;
            switch (this.keyWords == null ? 0 : this.keyWords.size()) {
                case 0: {
                    keyWords = Collections.emptySet();
                    break;
                }
                case 1: {
                    keyWords = Collections.singleton(this.keyWords.get(0));
                    break;
                }
                default: {
                    keyWords = new LinkedHashSet(this.keyWords.size() < 0x40000000 ? 1 + this.keyWords.size() + (this.keyWords.size() - 3) / 3 : Integer.MAX_VALUE);
                    keyWords.addAll(this.keyWords);
                    keyWords = Collections.unmodifiableSet(keyWords);
                }
            }
            switch (this.nextUnits == null ? 0 : this.nextUnits.size()) {
                case 0: {
                    nextUnits = Collections.emptySet();
                    break;
                }
                case 1: {
                    nextUnits = Collections.singleton(this.nextUnits.get(0));
                    break;
                }
                default: {
                    nextUnits = new LinkedHashSet(this.nextUnits.size() < 0x40000000 ? 1 + this.nextUnits.size() + (this.nextUnits.size() - 3) / 3 : Integer.MAX_VALUE);
                    nextUnits.addAll(this.nextUnits);
                    nextUnits = Collections.unmodifiableSet(nextUnits);
                }
            }
            return new AnswerCheck(keyWords, this.phrase, this.pattern, this.matchThreshold, this.priority, nextUnits, this.activeType, this.unitTrue, this.unitFalse, this.check);
        }

        public String toString() {
            return "AnswerCheck.AnswerCheckBuilder(keyWords=" + this.keyWords + ", phrase=" + this.phrase + ", pattern=" + this.pattern + ", matchThreshold=" + this.matchThreshold + ", priority=" + this.priority + ", nextUnits=" + this.nextUnits + ", activeType=" + (Object)((Object)this.activeType) + ", unitTrue=" + (Object)((Object)this.unitTrue) + ", unitFalse=" + (Object)((Object)this.unitFalse) + ", check=" + this.check + ")";
        }
    }
}

