/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.domain.unit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.domain.unit.UnitActiveType;
import org.sadtech.social.bot.service.usercode.ProcessingData;
import org.sadtech.social.core.domain.content.Message;
import org.sadtech.social.core.service.sender.Sending;

public class AnswerProcessing<M extends Message>
extends MainUnit {
    private final ProcessingData<M> processingData;
    private final Sending sending;

    private AnswerProcessing(Set<String> keyWords, String phrase, Pattern pattern, Integer matchThreshold, Integer priority, Set<MainUnit> nextUnits, UnitActiveType activeType, ProcessingData<M> processingData, Sending sending) {
        super(keyWords, phrase, pattern, matchThreshold, priority, nextUnits, activeType, "PROCESSING");
        this.processingData = processingData;
        this.sending = sending;
    }

    public static <M extends Message> AnswerProcessingBuilder<M> builder() {
        return new AnswerProcessingBuilder();
    }

    public ProcessingData<M> getProcessingData() {
        return this.processingData;
    }

    public Sending getSending() {
        return this.sending;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerProcessing)) {
            return false;
        }
        AnswerProcessing other = (AnswerProcessing)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProcessingData<M> this$processingData = this.getProcessingData();
        ProcessingData<M> other$processingData = other.getProcessingData();
        if (this$processingData == null ? other$processingData != null : !this$processingData.equals(other$processingData)) {
            return false;
        }
        Sending this$sending = this.getSending();
        Sending other$sending = other.getSending();
        return !(this$sending == null ? other$sending != null : !this$sending.equals(other$sending));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnswerProcessing;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ProcessingData<M> $processingData = this.getProcessingData();
        result = result * 59 + ($processingData == null ? 43 : $processingData.hashCode());
        Sending $sending = this.getSending();
        result = result * 59 + ($sending == null ? 43 : $sending.hashCode());
        return result;
    }

    public static class AnswerProcessingBuilder<M extends Message> {
        private ArrayList<String> keyWords;
        private String phrase;
        private Pattern pattern;
        private Integer matchThreshold;
        private Integer priority;
        private ArrayList<MainUnit> nextUnits;
        private UnitActiveType activeType;
        private ProcessingData<M> processingData;
        private Sending sending;

        AnswerProcessingBuilder() {
        }

        public AnswerProcessingBuilder<M> keyWord(String keyWord) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.add(keyWord);
            return this;
        }

        public AnswerProcessingBuilder<M> keyWords(Collection<? extends String> keyWords) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.addAll(keyWords);
            return this;
        }

        public AnswerProcessingBuilder<M> clearKeyWords() {
            if (this.keyWords != null) {
                this.keyWords.clear();
            }
            return this;
        }

        public AnswerProcessingBuilder<M> phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public AnswerProcessingBuilder<M> pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public AnswerProcessingBuilder<M> matchThreshold(Integer matchThreshold) {
            this.matchThreshold = matchThreshold;
            return this;
        }

        public AnswerProcessingBuilder<M> priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public AnswerProcessingBuilder<M> nextUnit(MainUnit nextUnit) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.add(nextUnit);
            return this;
        }

        public AnswerProcessingBuilder<M> nextUnits(Collection<? extends MainUnit> nextUnits) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.addAll(nextUnits);
            return this;
        }

        public AnswerProcessingBuilder<M> clearNextUnits() {
            if (this.nextUnits != null) {
                this.nextUnits.clear();
            }
            return this;
        }

        public AnswerProcessingBuilder<M> activeType(UnitActiveType activeType) {
            this.activeType = activeType;
            return this;
        }

        public AnswerProcessingBuilder<M> processingData(ProcessingData<M> processingData) {
            this.processingData = processingData;
            return this;
        }

        public AnswerProcessingBuilder<M> sending(Sending sending) {
            this.sending = sending;
            return this;
        }

        public AnswerProcessing<M> build() {
            Set<Object> nextUnits;
            Set<Object> keyWords;
            switch (this.keyWords == null ? 0 : this.keyWords.size()) {
                case 0: {
                    keyWords = Collections.emptySet();
                    break;
                }
                case 1: {
                    keyWords = Collections.singleton(this.keyWords.get(0));
                    break;
                }
                default: {
                    keyWords = new LinkedHashSet(this.keyWords.size() < 0x40000000 ? 1 + this.keyWords.size() + (this.keyWords.size() - 3) / 3 : Integer.MAX_VALUE);
                    keyWords.addAll(this.keyWords);
                    keyWords = Collections.unmodifiableSet(keyWords);
                }
            }
            switch (this.nextUnits == null ? 0 : this.nextUnits.size()) {
                case 0: {
                    nextUnits = Collections.emptySet();
                    break;
                }
                case 1: {
                    nextUnits = Collections.singleton(this.nextUnits.get(0));
                    break;
                }
                default: {
                    nextUnits = new LinkedHashSet(this.nextUnits.size() < 0x40000000 ? 1 + this.nextUnits.size() + (this.nextUnits.size() - 3) / 3 : Integer.MAX_VALUE);
                    nextUnits.addAll(this.nextUnits);
                    nextUnits = Collections.unmodifiableSet(nextUnits);
                }
            }
            return new AnswerProcessing(keyWords, this.phrase, this.pattern, this.matchThreshold, this.priority, nextUnits, this.activeType, this.processingData, this.sending);
        }

        public String toString() {
            return "AnswerProcessing.AnswerProcessingBuilder(keyWords=" + this.keyWords + ", phrase=" + this.phrase + ", pattern=" + this.pattern + ", matchThreshold=" + this.matchThreshold + ", priority=" + this.priority + ", nextUnits=" + this.nextUnits + ", activeType=" + (Object)((Object)this.activeType) + ", processingData=" + this.processingData + ", sending=" + this.sending + ")";
        }
    }
}

