/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.domain.unit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.domain.unit.UnitActiveType;
import org.sadtech.social.bot.service.save.CheckSave;
import org.sadtech.social.bot.service.save.Preservable;
import org.sadtech.social.bot.service.save.data.PreservableData;
import org.sadtech.social.bot.service.save.push.Pusher;
import org.sadtech.social.core.domain.content.Message;

public class AnswerSave<D>
extends MainUnit {
    private final Preservable<D> preservable;
    private final String key;
    private final Pusher<D> pusher;
    private final PreservableData<D, ? super Message> preservableData;
    private final boolean hidden;
    private final CheckSave<? super Message> checkSave;

    private AnswerSave(Set<String> keyWords, String phrase, Pattern pattern, Integer matchThreshold, Integer priority, Set<MainUnit> nextUnits, Preservable<D> preservable, String key, Pusher<D> pusher, PreservableData<D, ? super Message> preservableData, CheckSave<? super Message> checkSave, boolean hidden) {
        super(keyWords, phrase, pattern, matchThreshold, priority, nextUnits, hidden ? UnitActiveType.AFTER : UnitActiveType.DEFAULT, "SAVE");
        this.key = key;
        this.pusher = pusher;
        this.maintenanceNextUnit(nextUnits);
        this.preservable = preservable;
        this.preservableData = preservableData;
        this.hidden = Optional.of(hidden).orElse(false);
        this.checkSave = checkSave;
    }

    private void maintenanceNextUnit(Collection<MainUnit> units) {
        if (units != null) {
            units.forEach(mainUnit -> mainUnit.setActiveType(UnitActiveType.AFTER));
        }
    }

    public static <D> AnswerSaveBuilder<D> builder() {
        return new AnswerSaveBuilder();
    }

    public Preservable<D> getPreservable() {
        return this.preservable;
    }

    public String getKey() {
        return this.key;
    }

    public Pusher<D> getPusher() {
        return this.pusher;
    }

    public PreservableData<D, ? super Message> getPreservableData() {
        return this.preservableData;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public CheckSave<? super Message> getCheckSave() {
        return this.checkSave;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerSave)) {
            return false;
        }
        AnswerSave other = (AnswerSave)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Preservable<D> this$preservable = this.getPreservable();
        Preservable<D> other$preservable = other.getPreservable();
        if (this$preservable == null ? other$preservable != null : !this$preservable.equals(other$preservable)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Pusher<D> this$pusher = this.getPusher();
        Pusher<D> other$pusher = other.getPusher();
        if (this$pusher == null ? other$pusher != null : !this$pusher.equals(other$pusher)) {
            return false;
        }
        PreservableData<D, Message> this$preservableData = this.getPreservableData();
        PreservableData<D, Message> other$preservableData = other.getPreservableData();
        if (this$preservableData == null ? other$preservableData != null : !this$preservableData.equals(other$preservableData)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        CheckSave<Message> this$checkSave = this.getCheckSave();
        CheckSave<Message> other$checkSave = other.getCheckSave();
        return !(this$checkSave == null ? other$checkSave != null : !this$checkSave.equals(other$checkSave));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnswerSave;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Preservable<D> $preservable = this.getPreservable();
        result = result * 59 + ($preservable == null ? 43 : $preservable.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Pusher<D> $pusher = this.getPusher();
        result = result * 59 + ($pusher == null ? 43 : $pusher.hashCode());
        PreservableData<D, Message> $preservableData = this.getPreservableData();
        result = result * 59 + ($preservableData == null ? 43 : $preservableData.hashCode());
        result = result * 59 + (this.isHidden() ? 79 : 97);
        CheckSave<Message> $checkSave = this.getCheckSave();
        result = result * 59 + ($checkSave == null ? 43 : $checkSave.hashCode());
        return result;
    }

    public static class AnswerSaveBuilder<D> {
        private ArrayList<String> keyWords;
        private String phrase;
        private Pattern pattern;
        private Integer matchThreshold;
        private Integer priority;
        private ArrayList<MainUnit> nextUnits;
        private Preservable<D> preservable;
        private String key;
        private Pusher<D> pusher;
        private PreservableData<D, ? super Message> preservableData;
        private CheckSave<? super Message> checkSave;
        private boolean hidden;

        AnswerSaveBuilder() {
        }

        public AnswerSaveBuilder<D> keyWord(String keyWord) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.add(keyWord);
            return this;
        }

        public AnswerSaveBuilder<D> keyWords(Collection<? extends String> keyWords) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.addAll(keyWords);
            return this;
        }

        public AnswerSaveBuilder<D> clearKeyWords() {
            if (this.keyWords != null) {
                this.keyWords.clear();
            }
            return this;
        }

        public AnswerSaveBuilder<D> phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public AnswerSaveBuilder<D> pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public AnswerSaveBuilder<D> matchThreshold(Integer matchThreshold) {
            this.matchThreshold = matchThreshold;
            return this;
        }

        public AnswerSaveBuilder<D> priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public AnswerSaveBuilder<D> nextUnit(MainUnit nextUnit) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.add(nextUnit);
            return this;
        }

        public AnswerSaveBuilder<D> nextUnits(Collection<? extends MainUnit> nextUnits) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.addAll(nextUnits);
            return this;
        }

        public AnswerSaveBuilder<D> clearNextUnits() {
            if (this.nextUnits != null) {
                this.nextUnits.clear();
            }
            return this;
        }

        public AnswerSaveBuilder<D> preservable(Preservable<D> preservable) {
            this.preservable = preservable;
            return this;
        }

        public AnswerSaveBuilder<D> key(String key) {
            this.key = key;
            return this;
        }

        public AnswerSaveBuilder<D> pusher(Pusher<D> pusher) {
            this.pusher = pusher;
            return this;
        }

        public AnswerSaveBuilder<D> preservableData(PreservableData<D, ? super Message> preservableData) {
            this.preservableData = preservableData;
            return this;
        }

        public AnswerSaveBuilder<D> checkSave(CheckSave<? super Message> checkSave) {
            this.checkSave = checkSave;
            return this;
        }

        public AnswerSaveBuilder<D> hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public AnswerSave<D> build() {
            Set<Object> nextUnits;
            Set<Object> keyWords;
            switch (this.keyWords == null ? 0 : this.keyWords.size()) {
                case 0: {
                    keyWords = Collections.emptySet();
                    break;
                }
                case 1: {
                    keyWords = Collections.singleton(this.keyWords.get(0));
                    break;
                }
                default: {
                    keyWords = new LinkedHashSet(this.keyWords.size() < 0x40000000 ? 1 + this.keyWords.size() + (this.keyWords.size() - 3) / 3 : Integer.MAX_VALUE);
                    keyWords.addAll(this.keyWords);
                    keyWords = Collections.unmodifiableSet(keyWords);
                }
            }
            switch (this.nextUnits == null ? 0 : this.nextUnits.size()) {
                case 0: {
                    nextUnits = Collections.emptySet();
                    break;
                }
                case 1: {
                    nextUnits = Collections.singleton(this.nextUnits.get(0));
                    break;
                }
                default: {
                    nextUnits = new LinkedHashSet(this.nextUnits.size() < 0x40000000 ? 1 + this.nextUnits.size() + (this.nextUnits.size() - 3) / 3 : Integer.MAX_VALUE);
                    nextUnits.addAll(this.nextUnits);
                    nextUnits = Collections.unmodifiableSet(nextUnits);
                }
            }
            return new AnswerSave(keyWords, this.phrase, this.pattern, this.matchThreshold, this.priority, nextUnits, this.preservable, this.key, this.pusher, this.preservableData, this.checkSave, this.hidden);
        }

        public String toString() {
            return "AnswerSave.AnswerSaveBuilder(keyWords=" + this.keyWords + ", phrase=" + this.phrase + ", pattern=" + this.pattern + ", matchThreshold=" + this.matchThreshold + ", priority=" + this.priority + ", nextUnits=" + this.nextUnits + ", preservable=" + this.preservable + ", key=" + this.key + ", pusher=" + this.pusher + ", preservableData=" + this.preservableData + ", checkSave=" + this.checkSave + ", hidden=" + this.hidden + ")";
        }
    }
}

