/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.domain.unit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.domain.unit.UnitActiveType;
import org.sadtech.social.bot.service.usercode.Insert;
import org.sadtech.social.core.domain.BoxAnswer;
import org.sadtech.social.core.service.sender.Sending;

public class AnswerText
extends MainUnit {
    private final BoxAnswer boxAnswer;
    private final Insert insert;
    private final Sending sending;

    private AnswerText(Set<String> keyWords, String phrase, Pattern pattern, Integer matchThreshold, Integer priority, Set<MainUnit> nextUnits, UnitActiveType activeType, BoxAnswer boxAnswer, Insert insert, Sending sending) {
        super(keyWords, phrase, pattern, matchThreshold, priority, nextUnits, activeType, "TEXT");
        this.boxAnswer = boxAnswer;
        this.insert = insert;
        this.sending = sending;
    }

    public static AnswerText of(String message) {
        return AnswerText.builder().boxAnswer(BoxAnswer.of((String)message)).build();
    }

    public static AnswerTextBuilder builder() {
        return new AnswerTextBuilder();
    }

    public AnswerTextBuilder toBuilder() {
        AnswerTextBuilder builder = new AnswerTextBuilder().phrase(this.phrase).pattern(this.pattern).matchThreshold(this.matchThreshold).priority(this.priority).activeType(this.activeType).boxAnswer(this.boxAnswer).insert(this.insert).sending(this.sending);
        if (this.keyWords != null) {
            builder.keyWords(this.keyWords);
        }
        if (this.nextUnits != null) {
            builder.nextUnits(this.nextUnits);
        }
        return builder;
    }

    public BoxAnswer getBoxAnswer() {
        return this.boxAnswer;
    }

    public Insert getInsert() {
        return this.insert;
    }

    public Sending getSending() {
        return this.sending;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerText)) {
            return false;
        }
        AnswerText other = (AnswerText)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BoxAnswer this$boxAnswer = this.getBoxAnswer();
        BoxAnswer other$boxAnswer = other.getBoxAnswer();
        if (this$boxAnswer == null ? other$boxAnswer != null : !this$boxAnswer.equals(other$boxAnswer)) {
            return false;
        }
        Insert this$insert = this.getInsert();
        Insert other$insert = other.getInsert();
        if (this$insert == null ? other$insert != null : !this$insert.equals(other$insert)) {
            return false;
        }
        Sending this$sending = this.getSending();
        Sending other$sending = other.getSending();
        return !(this$sending == null ? other$sending != null : !this$sending.equals(other$sending));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnswerText;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BoxAnswer $boxAnswer = this.getBoxAnswer();
        result = result * 59 + ($boxAnswer == null ? 43 : $boxAnswer.hashCode());
        Insert $insert = this.getInsert();
        result = result * 59 + ($insert == null ? 43 : $insert.hashCode());
        Sending $sending = this.getSending();
        result = result * 59 + ($sending == null ? 43 : $sending.hashCode());
        return result;
    }

    public static class AnswerTextBuilder {
        private ArrayList<String> keyWords;
        private String phrase;
        private Pattern pattern;
        private Integer matchThreshold;
        private Integer priority;
        private ArrayList<MainUnit> nextUnits;
        private UnitActiveType activeType;
        private BoxAnswer boxAnswer;
        private Insert insert;
        private Sending sending;

        AnswerTextBuilder() {
        }

        public AnswerTextBuilder keyWord(String keyWord) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.add(keyWord);
            return this;
        }

        public AnswerTextBuilder keyWords(Collection<? extends String> keyWords) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.addAll(keyWords);
            return this;
        }

        public AnswerTextBuilder clearKeyWords() {
            if (this.keyWords != null) {
                this.keyWords.clear();
            }
            return this;
        }

        public AnswerTextBuilder phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public AnswerTextBuilder pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public AnswerTextBuilder matchThreshold(Integer matchThreshold) {
            this.matchThreshold = matchThreshold;
            return this;
        }

        public AnswerTextBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public AnswerTextBuilder nextUnit(MainUnit nextUnit) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.add(nextUnit);
            return this;
        }

        public AnswerTextBuilder nextUnits(Collection<? extends MainUnit> nextUnits) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.addAll(nextUnits);
            return this;
        }

        public AnswerTextBuilder clearNextUnits() {
            if (this.nextUnits != null) {
                this.nextUnits.clear();
            }
            return this;
        }

        public AnswerTextBuilder activeType(UnitActiveType activeType) {
            this.activeType = activeType;
            return this;
        }

        public AnswerTextBuilder boxAnswer(BoxAnswer boxAnswer) {
            this.boxAnswer = boxAnswer;
            return this;
        }

        public AnswerTextBuilder insert(Insert insert) {
            this.insert = insert;
            return this;
        }

        public AnswerTextBuilder sending(Sending sending) {
            this.sending = sending;
            return this;
        }

        public AnswerText build() {
            Set<Object> nextUnits;
            Set<Object> keyWords;
            switch (this.keyWords == null ? 0 : this.keyWords.size()) {
                case 0: {
                    keyWords = Collections.emptySet();
                    break;
                }
                case 1: {
                    keyWords = Collections.singleton(this.keyWords.get(0));
                    break;
                }
                default: {
                    keyWords = new LinkedHashSet(this.keyWords.size() < 0x40000000 ? 1 + this.keyWords.size() + (this.keyWords.size() - 3) / 3 : Integer.MAX_VALUE);
                    keyWords.addAll(this.keyWords);
                    keyWords = Collections.unmodifiableSet(keyWords);
                }
            }
            switch (this.nextUnits == null ? 0 : this.nextUnits.size()) {
                case 0: {
                    nextUnits = Collections.emptySet();
                    break;
                }
                case 1: {
                    nextUnits = Collections.singleton(this.nextUnits.get(0));
                    break;
                }
                default: {
                    nextUnits = new LinkedHashSet(this.nextUnits.size() < 0x40000000 ? 1 + this.nextUnits.size() + (this.nextUnits.size() - 3) / 3 : Integer.MAX_VALUE);
                    nextUnits.addAll(this.nextUnits);
                    nextUnits = Collections.unmodifiableSet(nextUnits);
                }
            }
            return new AnswerText(keyWords, this.phrase, this.pattern, this.matchThreshold, this.priority, nextUnits, this.activeType, this.boxAnswer, this.insert, this.sending);
        }

        public String toString() {
            return "AnswerText.AnswerTextBuilder(keyWords=" + this.keyWords + ", phrase=" + this.phrase + ", pattern=" + this.pattern + ", matchThreshold=" + this.matchThreshold + ", priority=" + this.priority + ", nextUnits=" + this.nextUnits + ", activeType=" + (Object)((Object)this.activeType) + ", boxAnswer=" + this.boxAnswer + ", insert=" + this.insert + ", sending=" + this.sending + ")";
        }
    }
}

