/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.domain.unit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.domain.unit.UnitActiveType;
import org.sadtech.social.bot.service.usercode.CheckData;

public class AnswerTimer
extends MainUnit {
    private final MainUnit unitAnswer;
    private final Integer timeDelaySec;
    private final Integer timeDeathSec;
    private final CheckData checkLoop;

    private AnswerTimer(Set<String> keyWords, String phrase, Pattern pattern, Integer matchThreshold, Integer priority, Set<MainUnit> nextUnits, UnitActiveType activeType, MainUnit unitAnswer, Integer timeDelaySec, Integer timeDeathSec, CheckData checkLoop) {
        super(keyWords, phrase, pattern, matchThreshold, priority, nextUnits, activeType == null ? UnitActiveType.AFTER : activeType, "TIMER");
        this.unitAnswer = unitAnswer;
        this.timeDelaySec = timeDelaySec;
        this.timeDeathSec = timeDeathSec;
        this.checkLoop = checkLoop;
    }

    public static AnswerTimerBuilder builder() {
        return new AnswerTimerBuilder();
    }

    public MainUnit getUnitAnswer() {
        return this.unitAnswer;
    }

    public Integer getTimeDelaySec() {
        return this.timeDelaySec;
    }

    public Integer getTimeDeathSec() {
        return this.timeDeathSec;
    }

    public CheckData getCheckLoop() {
        return this.checkLoop;
    }

    @Override
    public String toString() {
        return "AnswerTimer(unitAnswer=" + (Object)((Object)this.getUnitAnswer()) + ", timeDelaySec=" + this.getTimeDelaySec() + ", timeDeathSec=" + this.getTimeDeathSec() + ", checkLoop=" + this.getCheckLoop() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerTimer)) {
            return false;
        }
        AnswerTimer other = (AnswerTimer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MainUnit this$unitAnswer = this.getUnitAnswer();
        MainUnit other$unitAnswer = other.getUnitAnswer();
        if (this$unitAnswer == null ? other$unitAnswer != null : !((Object)((Object)this$unitAnswer)).equals((Object)other$unitAnswer)) {
            return false;
        }
        Integer this$timeDelaySec = this.getTimeDelaySec();
        Integer other$timeDelaySec = other.getTimeDelaySec();
        if (this$timeDelaySec == null ? other$timeDelaySec != null : !((Object)this$timeDelaySec).equals(other$timeDelaySec)) {
            return false;
        }
        Integer this$timeDeathSec = this.getTimeDeathSec();
        Integer other$timeDeathSec = other.getTimeDeathSec();
        if (this$timeDeathSec == null ? other$timeDeathSec != null : !((Object)this$timeDeathSec).equals(other$timeDeathSec)) {
            return false;
        }
        CheckData this$checkLoop = this.getCheckLoop();
        CheckData other$checkLoop = other.getCheckLoop();
        return !(this$checkLoop == null ? other$checkLoop != null : !this$checkLoop.equals(other$checkLoop));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnswerTimer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MainUnit $unitAnswer = this.getUnitAnswer();
        result = result * 59 + ($unitAnswer == null ? 43 : ((Object)((Object)$unitAnswer)).hashCode());
        Integer $timeDelaySec = this.getTimeDelaySec();
        result = result * 59 + ($timeDelaySec == null ? 43 : ((Object)$timeDelaySec).hashCode());
        Integer $timeDeathSec = this.getTimeDeathSec();
        result = result * 59 + ($timeDeathSec == null ? 43 : ((Object)$timeDeathSec).hashCode());
        CheckData $checkLoop = this.getCheckLoop();
        result = result * 59 + ($checkLoop == null ? 43 : $checkLoop.hashCode());
        return result;
    }

    public static class AnswerTimerBuilder {
        private ArrayList<String> keyWords;
        private String phrase;
        private Pattern pattern;
        private Integer matchThreshold;
        private Integer priority;
        private ArrayList<MainUnit> nextUnits;
        private UnitActiveType activeType;
        private MainUnit unitAnswer;
        private Integer timeDelaySec;
        private Integer timeDeathSec;
        private CheckData checkLoop;

        AnswerTimerBuilder() {
        }

        public AnswerTimerBuilder keyWord(String keyWord) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.add(keyWord);
            return this;
        }

        public AnswerTimerBuilder keyWords(Collection<? extends String> keyWords) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.addAll(keyWords);
            return this;
        }

        public AnswerTimerBuilder clearKeyWords() {
            if (this.keyWords != null) {
                this.keyWords.clear();
            }
            return this;
        }

        public AnswerTimerBuilder phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public AnswerTimerBuilder pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public AnswerTimerBuilder matchThreshold(Integer matchThreshold) {
            this.matchThreshold = matchThreshold;
            return this;
        }

        public AnswerTimerBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public AnswerTimerBuilder nextUnit(MainUnit nextUnit) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.add(nextUnit);
            return this;
        }

        public AnswerTimerBuilder nextUnits(Collection<? extends MainUnit> nextUnits) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.addAll(nextUnits);
            return this;
        }

        public AnswerTimerBuilder clearNextUnits() {
            if (this.nextUnits != null) {
                this.nextUnits.clear();
            }
            return this;
        }

        public AnswerTimerBuilder activeType(UnitActiveType activeType) {
            this.activeType = activeType;
            return this;
        }

        public AnswerTimerBuilder unitAnswer(MainUnit unitAnswer) {
            this.unitAnswer = unitAnswer;
            return this;
        }

        public AnswerTimerBuilder timeDelaySec(Integer timeDelaySec) {
            this.timeDelaySec = timeDelaySec;
            return this;
        }

        public AnswerTimerBuilder timeDeathSec(Integer timeDeathSec) {
            this.timeDeathSec = timeDeathSec;
            return this;
        }

        public AnswerTimerBuilder checkLoop(CheckData checkLoop) {
            this.checkLoop = checkLoop;
            return this;
        }

        public AnswerTimer build() {
            Set<Object> nextUnits;
            Set<Object> keyWords;
            switch (this.keyWords == null ? 0 : this.keyWords.size()) {
                case 0: {
                    keyWords = Collections.emptySet();
                    break;
                }
                case 1: {
                    keyWords = Collections.singleton(this.keyWords.get(0));
                    break;
                }
                default: {
                    keyWords = new LinkedHashSet(this.keyWords.size() < 0x40000000 ? 1 + this.keyWords.size() + (this.keyWords.size() - 3) / 3 : Integer.MAX_VALUE);
                    keyWords.addAll(this.keyWords);
                    keyWords = Collections.unmodifiableSet(keyWords);
                }
            }
            switch (this.nextUnits == null ? 0 : this.nextUnits.size()) {
                case 0: {
                    nextUnits = Collections.emptySet();
                    break;
                }
                case 1: {
                    nextUnits = Collections.singleton(this.nextUnits.get(0));
                    break;
                }
                default: {
                    nextUnits = new LinkedHashSet(this.nextUnits.size() < 0x40000000 ? 1 + this.nextUnits.size() + (this.nextUnits.size() - 3) / 3 : Integer.MAX_VALUE);
                    nextUnits.addAll(this.nextUnits);
                    nextUnits = Collections.unmodifiableSet(nextUnits);
                }
            }
            return new AnswerTimer(keyWords, this.phrase, this.pattern, this.matchThreshold, this.priority, nextUnits, this.activeType, this.unitAnswer, this.timeDelaySec, this.timeDeathSec, this.checkLoop);
        }

        public String toString() {
            return "AnswerTimer.AnswerTimerBuilder(keyWords=" + this.keyWords + ", phrase=" + this.phrase + ", pattern=" + this.pattern + ", matchThreshold=" + this.matchThreshold + ", priority=" + this.priority + ", nextUnits=" + this.nextUnits + ", activeType=" + (Object)((Object)this.activeType) + ", unitAnswer=" + (Object)((Object)this.unitAnswer) + ", timeDelaySec=" + this.timeDelaySec + ", timeDeathSec=" + this.timeDeathSec + ", checkLoop=" + this.checkLoop + ")";
        }
    }
}

