/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.domain.unit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.domain.unit.UnitActiveType;
import org.sadtech.social.bot.service.save.LocalPreservable;
import org.sadtech.social.bot.service.save.Preservable;
import org.sadtech.social.bot.service.usercode.ClarificationQuestion;

public class AnswerValidity
extends MainUnit {
    private final MainUnit unitYes;
    private final MainUnit unitNo;
    private final MainUnit unitNull;
    private final Preservable<String> tempSave = new LocalPreservable<String>();
    private final ClarificationQuestion clarificationQuestion;

    private AnswerValidity(Set<String> keyWords, String phrase, Pattern pattern, Integer matchThreshold, Integer priority, Set<MainUnit> nextUnits, UnitActiveType activeType, MainUnit unitYes, MainUnit unitNo, MainUnit unitNull, ClarificationQuestion clarificationQuestion) {
        super(keyWords, phrase, pattern, matchThreshold, priority, nextUnits, UnitActiveType.DEFAULT, "VALIDITY");
        this.unitYes = unitYes;
        this.unitNo = unitNo;
        this.unitNull = unitNull;
        this.clarificationQuestion = clarificationQuestion;
    }

    public static AnswerValidityBuilder builder() {
        return new AnswerValidityBuilder();
    }

    public AnswerValidityBuilder toBuilder() {
        AnswerValidityBuilder builder = new AnswerValidityBuilder().phrase(this.phrase).pattern(this.pattern).matchThreshold(this.matchThreshold).priority(this.priority).activeType(this.activeType).unitYes(this.unitYes).unitNo(this.unitNo).unitNull(this.unitNull).clarificationQuestion(this.clarificationQuestion);
        if (this.keyWords != null) {
            builder.keyWords(this.keyWords);
        }
        if (this.nextUnits != null) {
            builder.nextUnits(this.nextUnits);
        }
        return builder;
    }

    public MainUnit getUnitYes() {
        return this.unitYes;
    }

    public MainUnit getUnitNo() {
        return this.unitNo;
    }

    public MainUnit getUnitNull() {
        return this.unitNull;
    }

    public Preservable<String> getTempSave() {
        return this.tempSave;
    }

    public ClarificationQuestion getClarificationQuestion() {
        return this.clarificationQuestion;
    }

    @Override
    public String toString() {
        return "AnswerValidity(unitYes=" + (Object)((Object)this.getUnitYes()) + ", unitNo=" + (Object)((Object)this.getUnitNo()) + ", unitNull=" + (Object)((Object)this.getUnitNull()) + ", tempSave=" + this.getTempSave() + ", clarificationQuestion=" + this.getClarificationQuestion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerValidity)) {
            return false;
        }
        AnswerValidity other = (AnswerValidity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MainUnit this$unitYes = this.getUnitYes();
        MainUnit other$unitYes = other.getUnitYes();
        if (this$unitYes == null ? other$unitYes != null : !((Object)((Object)this$unitYes)).equals((Object)other$unitYes)) {
            return false;
        }
        MainUnit this$unitNo = this.getUnitNo();
        MainUnit other$unitNo = other.getUnitNo();
        if (this$unitNo == null ? other$unitNo != null : !((Object)((Object)this$unitNo)).equals((Object)other$unitNo)) {
            return false;
        }
        MainUnit this$unitNull = this.getUnitNull();
        MainUnit other$unitNull = other.getUnitNull();
        if (this$unitNull == null ? other$unitNull != null : !((Object)((Object)this$unitNull)).equals((Object)other$unitNull)) {
            return false;
        }
        Preservable<String> this$tempSave = this.getTempSave();
        Preservable<String> other$tempSave = other.getTempSave();
        if (this$tempSave == null ? other$tempSave != null : !this$tempSave.equals(other$tempSave)) {
            return false;
        }
        ClarificationQuestion this$clarificationQuestion = this.getClarificationQuestion();
        ClarificationQuestion other$clarificationQuestion = other.getClarificationQuestion();
        return !(this$clarificationQuestion == null ? other$clarificationQuestion != null : !this$clarificationQuestion.equals(other$clarificationQuestion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnswerValidity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MainUnit $unitYes = this.getUnitYes();
        result = result * 59 + ($unitYes == null ? 43 : ((Object)((Object)$unitYes)).hashCode());
        MainUnit $unitNo = this.getUnitNo();
        result = result * 59 + ($unitNo == null ? 43 : ((Object)((Object)$unitNo)).hashCode());
        MainUnit $unitNull = this.getUnitNull();
        result = result * 59 + ($unitNull == null ? 43 : ((Object)((Object)$unitNull)).hashCode());
        Preservable<String> $tempSave = this.getTempSave();
        result = result * 59 + ($tempSave == null ? 43 : $tempSave.hashCode());
        ClarificationQuestion $clarificationQuestion = this.getClarificationQuestion();
        result = result * 59 + ($clarificationQuestion == null ? 43 : $clarificationQuestion.hashCode());
        return result;
    }

    public static class AnswerValidityBuilder {
        private ArrayList<String> keyWords;
        private String phrase;
        private Pattern pattern;
        private Integer matchThreshold;
        private Integer priority;
        private ArrayList<MainUnit> nextUnits;
        private UnitActiveType activeType;
        private MainUnit unitYes;
        private MainUnit unitNo;
        private MainUnit unitNull;
        private ClarificationQuestion clarificationQuestion;

        AnswerValidityBuilder() {
        }

        public AnswerValidityBuilder keyWord(String keyWord) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.add(keyWord);
            return this;
        }

        public AnswerValidityBuilder keyWords(Collection<? extends String> keyWords) {
            if (this.keyWords == null) {
                this.keyWords = new ArrayList();
            }
            this.keyWords.addAll(keyWords);
            return this;
        }

        public AnswerValidityBuilder clearKeyWords() {
            if (this.keyWords != null) {
                this.keyWords.clear();
            }
            return this;
        }

        public AnswerValidityBuilder phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public AnswerValidityBuilder pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public AnswerValidityBuilder matchThreshold(Integer matchThreshold) {
            this.matchThreshold = matchThreshold;
            return this;
        }

        public AnswerValidityBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public AnswerValidityBuilder nextUnit(MainUnit nextUnit) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.add(nextUnit);
            return this;
        }

        public AnswerValidityBuilder nextUnits(Collection<? extends MainUnit> nextUnits) {
            if (this.nextUnits == null) {
                this.nextUnits = new ArrayList();
            }
            this.nextUnits.addAll(nextUnits);
            return this;
        }

        public AnswerValidityBuilder clearNextUnits() {
            if (this.nextUnits != null) {
                this.nextUnits.clear();
            }
            return this;
        }

        public AnswerValidityBuilder activeType(UnitActiveType activeType) {
            this.activeType = activeType;
            return this;
        }

        public AnswerValidityBuilder unitYes(MainUnit unitYes) {
            this.unitYes = unitYes;
            return this;
        }

        public AnswerValidityBuilder unitNo(MainUnit unitNo) {
            this.unitNo = unitNo;
            return this;
        }

        public AnswerValidityBuilder unitNull(MainUnit unitNull) {
            this.unitNull = unitNull;
            return this;
        }

        public AnswerValidityBuilder clarificationQuestion(ClarificationQuestion clarificationQuestion) {
            this.clarificationQuestion = clarificationQuestion;
            return this;
        }

        public AnswerValidity build() {
            Set<Object> nextUnits;
            Set<Object> keyWords;
            switch (this.keyWords == null ? 0 : this.keyWords.size()) {
                case 0: {
                    keyWords = Collections.emptySet();
                    break;
                }
                case 1: {
                    keyWords = Collections.singleton(this.keyWords.get(0));
                    break;
                }
                default: {
                    keyWords = new LinkedHashSet(this.keyWords.size() < 0x40000000 ? 1 + this.keyWords.size() + (this.keyWords.size() - 3) / 3 : Integer.MAX_VALUE);
                    keyWords.addAll(this.keyWords);
                    keyWords = Collections.unmodifiableSet(keyWords);
                }
            }
            switch (this.nextUnits == null ? 0 : this.nextUnits.size()) {
                case 0: {
                    nextUnits = Collections.emptySet();
                    break;
                }
                case 1: {
                    nextUnits = Collections.singleton(this.nextUnits.get(0));
                    break;
                }
                default: {
                    nextUnits = new LinkedHashSet(this.nextUnits.size() < 0x40000000 ? 1 + this.nextUnits.size() + (this.nextUnits.size() - 3) / 3 : Integer.MAX_VALUE);
                    nextUnits.addAll(this.nextUnits);
                    nextUnits = Collections.unmodifiableSet(nextUnits);
                }
            }
            return new AnswerValidity(keyWords, this.phrase, this.pattern, this.matchThreshold, this.priority, nextUnits, this.activeType, this.unitYes, this.unitNo, this.unitNull, this.clarificationQuestion);
        }

        public String toString() {
            return "AnswerValidity.AnswerValidityBuilder(keyWords=" + this.keyWords + ", phrase=" + this.phrase + ", pattern=" + this.pattern + ", matchThreshold=" + this.matchThreshold + ", priority=" + this.priority + ", nextUnits=" + this.nextUnits + ", activeType=" + (Object)((Object)this.activeType) + ", unitYes=" + (Object)((Object)this.unitYes) + ", unitNo=" + (Object)((Object)this.unitNo) + ", unitNull=" + (Object)((Object)this.unitNull) + ", clarificationQuestion=" + this.clarificationQuestion + ")";
        }
    }
}

