/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.domain.unit;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.sadtech.autoresponder.entity.Unit;
import org.sadtech.social.bot.domain.unit.UnitActiveType;

public abstract class MainUnit
extends Unit<MainUnit> {
    private String uuid = UUID.randomUUID().toString();
    protected final String type;
    protected UnitActiveType activeType;

    protected MainUnit(Set<String> keyWords, String phrase, Pattern pattern, Integer matchThreshold, Integer priority, Set<MainUnit> nextUnits, UnitActiveType activeType, String type) {
        super(keyWords, phrase, pattern, matchThreshold, priority, nextUnits);
        this.activeType = Optional.ofNullable(activeType).orElse(UnitActiveType.DEFAULT);
        this.type = type;
    }

    public String toString() {
        return "MainUnit(uuid=" + this.getUuid() + ", type=" + this.getType() + ", activeType=" + (Object)((Object)this.getActiveType()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MainUnit)) {
            return false;
        }
        MainUnit other = (MainUnit)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UnitActiveType this$activeType = this.getActiveType();
        UnitActiveType other$activeType = other.getActiveType();
        return !(this$activeType == null ? other$activeType != null : !((Object)((Object)this$activeType)).equals((Object)other$activeType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MainUnit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UnitActiveType $activeType = this.getActiveType();
        result = result * 59 + ($activeType == null ? 43 : ((Object)((Object)$activeType)).hashCode());
        return result;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getType() {
        return this.type;
    }

    public UnitActiveType getActiveType() {
        return this.activeType;
    }

    public void setActiveType(UnitActiveType activeType) {
        this.activeType = activeType;
    }
}

