/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.service.action;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.sadtech.social.bot.domain.AccountAutoCheck;
import org.sadtech.social.bot.domain.Timer;
import org.sadtech.social.bot.domain.unit.AnswerAccount;
import org.sadtech.social.bot.domain.unit.AnswerText;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.service.action.ActionUnit;
import org.sadtech.social.bot.service.timer.TimerService;
import org.sadtech.social.core.domain.BoxAnswer;
import org.sadtech.social.core.domain.content.Mail;
import org.sadtech.social.core.domain.keyboard.KeyBoardButton;
import org.sadtech.social.core.domain.keyboard.button.KeyBoardButtonAccount;
import org.sadtech.social.core.domain.money.Account;
import org.sadtech.social.core.service.AccountService;
import org.sadtech.social.core.utils.KeyBoards;

public class AnswerAccountAction
implements ActionUnit<AnswerAccount, Mail> {
    private final AccountService accountService;
    private TimerService timerService;

    public AnswerAccountAction(AccountService accountService, TimerService timerService) {
        this.accountService = accountService;
        this.timerService = timerService;
    }

    public AnswerAccountAction(AccountService accountService) {
        this.accountService = accountService;
    }

    @Override
    public MainUnit action(AnswerAccount answerAccount, Mail mail) {
        Account account = new Account();
        account.setBelongsPersonId(mail.getPersonId());
        account.setTotalSum(answerAccount.getTotalSum());
        Integer accountId = this.accountService.add(account).getId();
        this.settingCheckTimer(answerAccount, mail, accountId);
        KeyBoardButtonAccount buttonAccount = KeyBoardButtonAccount.builder().accountId(accountId).amount(answerAccount.getTotalSum()).build();
        BoxAnswer boxAnswer = BoxAnswer.builder().message("\u0414\u043b\u044f \u043e\u043f\u043b\u0430\u0442\u044b \u0443\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u0441\u0447\u0435\u0442\u0430 " + accountId + "\n\u0421\u0443\u043c\u043c\u0430 \u043a \u043e\u043f\u043b\u0430\u0442\u0435: " + answerAccount.getTotalSum()).keyBoard(KeyBoards.singelton((KeyBoardButton)buttonAccount)).build();
        return AnswerText.builder().boxAnswer(boxAnswer).build();
    }

    private void settingCheckTimer(AnswerAccount answerAccount, Mail mail, Integer accountId) {
        AccountAutoCheck autoCheck = answerAccount.getAutoCheck();
        if (autoCheck != null && this.timerService != null) {
            Timer timer = Timer.builder().personId(mail.getPersonId()).unitAnswer(autoCheck.getSuccessfulPayment()).unitDeath(autoCheck.getFailedPayment()).checkLoop(content1 -> this.accountService.paymentVerification(accountId)).periodSec(autoCheck.getPeriodSec()).timeActive(LocalDateTime.now(Clock.tickSeconds(ZoneId.systemDefault())).plusSeconds(autoCheck.getPeriodSec().intValue())).timeDeath(LocalDateTime.now(Clock.tickSeconds(ZoneId.systemDefault())).plusHours(autoCheck.getLifeTimeHours().intValue())).build();
            this.timerService.add(timer);
        }
    }
}

