/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.service.action;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import java.util.TimerTask;
import org.sadtech.social.bot.GeneralAutoResponder;
import org.sadtech.social.bot.domain.Timer;
import org.sadtech.social.bot.domain.unit.AnswerTimer;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.service.action.ActionUnit;
import org.sadtech.social.bot.service.timer.TimerActionTask;
import org.sadtech.social.bot.service.timer.TimerService;
import org.sadtech.social.core.domain.content.Message;
import org.sadtech.social.core.exception.TimerSettingException;

public class AnswerTimerAction
implements ActionUnit<AnswerTimer, Message> {
    private TimerService timerService;
    private Long verificationPeriodSec = 15L;

    public AnswerTimerAction(TimerService timerService, GeneralAutoResponder generalAutoresponder) {
        this.timerService = timerService;
        TimerActionTask timerActionTask = new TimerActionTask(timerService, generalAutoresponder);
        java.util.Timer timer = new java.util.Timer(true);
        timer.schedule((TimerTask)timerActionTask, 0L, 1000L * this.verificationPeriodSec);
    }

    public Long getVerificationPeriodSec() {
        return this.verificationPeriodSec;
    }

    public void setVerificationPeriodSec(Long verificationPeriodSec) {
        this.verificationPeriodSec = verificationPeriodSec;
    }

    @Override
    public MainUnit action(AnswerTimer answerTimer, Message message) {
        LocalDateTime timeActive = LocalDateTime.now(Clock.tickSeconds(ZoneId.systemDefault())).plusSeconds(Optional.ofNullable(answerTimer.getTimeDelaySec()).orElseThrow(() -> new TimerSettingException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u0442\u0430\u0439\u043c\u0435\u0440\u0430")).intValue());
        Timer.TimerBuilder timer = Timer.builder().personId(message.getPersonId()).unitAnswer(answerTimer.getUnitAnswer()).timeActive(timeActive).periodSec(answerTimer.getTimeDelaySec()).checkLoop(answerTimer.getCheckLoop());
        if (answerTimer.getTimeDeathSec() != null) {
            timer.timeDeath(LocalDateTime.now(Clock.tickSeconds(ZoneId.systemDefault())).plusSeconds(answerTimer.getTimeDeathSec().intValue()));
        } else if (answerTimer.getCheckLoop() == null) {
            timer.timeDeath(timeActive);
        }
        this.timerService.add(timer.build());
        return answerTimer;
    }
}

