/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.service.action;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sadtech.social.bot.domain.Clarification;
import org.sadtech.social.bot.domain.unit.AnswerText;
import org.sadtech.social.bot.domain.unit.AnswerValidity;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.bot.service.action.ActionUnit;
import org.sadtech.social.core.domain.content.Message;

public class AnswerValidityAction
implements ActionUnit<AnswerValidity, Message> {
    public static final Set<String> WORDS_YES = Collections.unmodifiableSet(Stream.of("\u0434\u0430", "\u0430\u0433\u0430").collect(Collectors.toSet()));
    public static final Set<String> WORDS_NO = Collections.unmodifiableSet(Stream.of("\u043d\u0435\u0442", "\u043d\u0435\u0430").collect(Collectors.toSet()));
    public static final Set<String> WORDS_YES_NO = Collections.unmodifiableSet(Stream.of("\u0434\u0430", "\u0430\u0433\u0430", "\u043d\u0435\u0442", "\u043d\u0435\u0430").collect(Collectors.toSet()));

    @Override
    public MainUnit action(AnswerValidity unit, Message content) {
        String message = content.getText();
        Long personId = content.getPersonId();
        if (WORDS_YES.contains(message.toLowerCase())) {
            unit.getTempSave().getByKey(personId, "temp").ifPresent(arg_0 -> ((Message)content).setText(arg_0));
            return unit.getUnitYes();
        }
        if (WORDS_NO.contains(message.toLowerCase())) {
            unit.getTempSave().getByKey(personId, "temp").ifPresent(arg_0 -> ((Message)content).setText(arg_0));
            return unit.getUnitNo();
        }
        Clarification clarification = unit.getClarificationQuestion().getClarification(content);
        String value = clarification.getValue();
        if (value == null) {
            return unit.getUnitNull();
        }
        unit.getTempSave().save(personId, "temp", value);
        AnswerValidity newValidity = unit.toBuilder().clearKeyWords().keyWords(WORDS_YES_NO).build();
        return AnswerText.builder().boxAnswer(clarification.getQuestion()).nextUnit(newValidity).build();
    }
}

