/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.service.timer;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.TimerTask;
import org.sadtech.social.bot.GeneralAutoResponder;
import org.sadtech.social.bot.domain.Timer;
import org.sadtech.social.bot.service.timer.TimerService;
import org.sadtech.social.bot.service.usercode.CheckData;
import org.sadtech.social.core.domain.content.EmptyMessage;
import org.sadtech.social.core.domain.content.Message;
import org.sadtech.social.core.utils.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerActionTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(TimerActionTask.class);
    private final TimerService timerService;
    private final GeneralAutoResponder generalAutoresponder;

    public TimerActionTask(TimerService timerService, GeneralAutoResponder generalAutoresponder) {
        this.generalAutoresponder = generalAutoresponder;
        log.info("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u043f\u043e \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0442\u0430\u0439\u043c\u0435\u0440\u043e\u0432");
        this.timerService = timerService;
    }

    @Override
    public void run() {
        LocalDateTime nowDate = LocalDateTime.now(Clock.tickSeconds(ZoneId.systemDefault()));
        log.info("\u0421\u0435\u0440\u0432\u0438\u0441 \u0442\u0430\u0439\u043c\u0435\u0440\u043e\u0432 \u0441\u0440\u0430\u0431\u043e\u0442\u0430\u043b. \u0412\u0440\u0435\u043c\u044f: {}", (Object)nowDate);
        this.timerService.getTimerActive().parallelStream().forEach(timer -> this.processingTimer((Timer)timer, nowDate));
    }

    private void processingTimer(Timer timer, LocalDateTime nowDate) {
        EmptyMessage emptyMessage = MessageUtils.EMPTY_MESSAGE;
        emptyMessage.setPersonId(timer.getPersonId());
        CheckData checkLoop = timer.getCheckLoop();
        if (!this.timeDeath(nowDate, timer.getTimeDeath())) {
            if (checkLoop != null) {
                if (checkLoop.checked(emptyMessage)) {
                    this.generalAutoresponder.answer(emptyMessage, timer.getUnitAnswer());
                    this.timerService.remove(timer.getId());
                } else {
                    this.reinstallation(timer);
                }
            } else {
                this.generalAutoresponder.answer(emptyMessage, timer.getUnitAnswer());
                this.reinstallation(timer);
            }
        } else {
            this.generalAutoresponder.answer(emptyMessage, timer.getUnitAnswer());
            this.death(timer, (Message)emptyMessage);
        }
    }

    private void reinstallation(Timer timer) {
        if (timer.getPeriodSec() != null) {
            timer.setTimeActive(timer.getTimeActive().plusSeconds(timer.getPeriodSec().intValue()));
            this.timerService.edit(timer.getId(), timer);
        }
    }

    private void death(Timer timer, Message emptyMessage) {
        if (timer.getUnitDeath() != null) {
            this.generalAutoresponder.answer(emptyMessage, timer.getUnitDeath());
        }
        this.timerService.remove(timer.getId());
    }

    private boolean timeDeath(LocalDateTime nowTime, LocalDateTime timeDeath) {
        return timeDeath != null && nowTime.isAfter(timeDeath);
    }
}

