/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.bot.service.timer;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.sadtech.social.bot.domain.Timer;
import org.sadtech.social.bot.repository.TimerRepository;
import org.sadtech.social.bot.service.timer.TimerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerServiceImpl
implements TimerService {
    private static final Logger log = LoggerFactory.getLogger(TimerServiceImpl.class);
    private final TimerRepository timerRepository;

    public TimerRepository getTimerRepository() {
        return this.timerRepository;
    }

    @Override
    public List<Timer> getTimerActive() {
        return new ArrayList<Timer>(this.timerRepository.getTimerActive(LocalDateTime.now()));
    }

    @Override
    public Integer add(Timer timer) {
        log.info("\u0422\u0430\u0439\u043c\u0435\u0440 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d: {}", (Object)timer);
        return this.timerRepository.add(timer);
    }

    @Override
    public void remove(Integer id) {
        log.info("\u0422\u0430\u0439\u043c\u0435\u0440 \u0443\u0434\u0430\u043b\u0435\u043d");
        this.timerRepository.remove(id);
    }

    @Override
    public void edit(Integer id, Timer timer) {
        timer.setId(id);
        this.timerRepository.edit(timer);
    }

    public TimerServiceImpl(TimerRepository timerRepository) {
        this.timerRepository = timerRepository;
    }
}

