/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.domain;

import org.sadtech.social.core.domain.content.attachment.GeoCoordinate;
import org.sadtech.social.core.domain.keyboard.KeyBoard;

public class BoxAnswer {
    private String message;
    private KeyBoard keyBoard;
    private GeoCoordinate coordinates;
    private Integer stickerId;

    public static BoxAnswer of(String message) {
        return BoxAnswer.builder().message(message).build();
    }

    BoxAnswer(String message, KeyBoard keyBoard, GeoCoordinate coordinates, Integer stickerId) {
        this.message = message;
        this.keyBoard = keyBoard;
        this.coordinates = coordinates;
        this.stickerId = stickerId;
    }

    public static BoxAnswerBuilder builder() {
        return new BoxAnswerBuilder();
    }

    public BoxAnswerBuilder toBuilder() {
        return new BoxAnswerBuilder().message(this.message).keyBoard(this.keyBoard).coordinates(this.coordinates).stickerId(this.stickerId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoxAnswer)) {
            return false;
        }
        BoxAnswer other = (BoxAnswer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        KeyBoard this$keyBoard = this.getKeyBoard();
        KeyBoard other$keyBoard = other.getKeyBoard();
        if (this$keyBoard == null ? other$keyBoard != null : !((Object)this$keyBoard).equals(other$keyBoard)) {
            return false;
        }
        GeoCoordinate this$coordinates = this.getCoordinates();
        GeoCoordinate other$coordinates = other.getCoordinates();
        if (this$coordinates == null ? other$coordinates != null : !((Object)this$coordinates).equals(other$coordinates)) {
            return false;
        }
        Integer this$stickerId = this.getStickerId();
        Integer other$stickerId = other.getStickerId();
        return !(this$stickerId == null ? other$stickerId != null : !((Object)this$stickerId).equals(other$stickerId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoxAnswer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        KeyBoard $keyBoard = this.getKeyBoard();
        result = result * 59 + ($keyBoard == null ? 43 : ((Object)$keyBoard).hashCode());
        GeoCoordinate $coordinates = this.getCoordinates();
        result = result * 59 + ($coordinates == null ? 43 : ((Object)$coordinates).hashCode());
        Integer $stickerId = this.getStickerId();
        result = result * 59 + ($stickerId == null ? 43 : ((Object)$stickerId).hashCode());
        return result;
    }

    public String toString() {
        return "BoxAnswer(message=" + this.getMessage() + ", keyBoard=" + this.getKeyBoard() + ", coordinates=" + this.getCoordinates() + ", stickerId=" + this.getStickerId() + ")";
    }

    public String getMessage() {
        return this.message;
    }

    public KeyBoard getKeyBoard() {
        return this.keyBoard;
    }

    public GeoCoordinate getCoordinates() {
        return this.coordinates;
    }

    public Integer getStickerId() {
        return this.stickerId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static class BoxAnswerBuilder {
        private String message;
        private KeyBoard keyBoard;
        private GeoCoordinate coordinates;
        private Integer stickerId;

        BoxAnswerBuilder() {
        }

        public BoxAnswerBuilder message(String message) {
            this.message = message;
            return this;
        }

        public BoxAnswerBuilder keyBoard(KeyBoard keyBoard) {
            this.keyBoard = keyBoard;
            return this;
        }

        public BoxAnswerBuilder coordinates(GeoCoordinate coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public BoxAnswerBuilder stickerId(Integer stickerId) {
            this.stickerId = stickerId;
            return this;
        }

        public BoxAnswer build() {
            return new BoxAnswer(this.message, this.keyBoard, this.coordinates, this.stickerId);
        }

        public String toString() {
            return "BoxAnswer.BoxAnswerBuilder(message=" + this.message + ", keyBoard=" + this.keyBoard + ", coordinates=" + this.coordinates + ", stickerId=" + this.stickerId + ")";
        }
    }
}

