/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.domain.content;

import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;
import org.sadtech.social.core.domain.BasicEntity;
import org.sadtech.social.core.domain.content.ContentType;

@MappedSuperclass
public abstract class Message
extends BasicEntity {
    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    protected ContentType type;
    @NotNull
    @Column(name="create_date")
    private LocalDateTime createDate;
    @Column(name="add_date")
    private LocalDateTime addDate;
    @NotNull
    @Column(name="person_id")
    private Long personId;
    @Column(name="text")
    private String text;

    public Message() {
    }

    public Message(Message source) {
        this.personId = source.getPersonId();
        this.text = source.getText();
        this.createDate = source.getCreateDate();
        this.id = source.getPersonId();
        this.type = source.getType();
    }

    public ContentType getType() {
        return this.type;
    }

    public LocalDateTime getCreateDate() {
        return this.createDate;
    }

    public LocalDateTime getAddDate() {
        return this.addDate;
    }

    public Long getPersonId() {
        return this.personId;
    }

    public String getText() {
        return this.text;
    }

    public void setType(ContentType type) {
        this.type = type;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    public void setAddDate(LocalDateTime addDate) {
        this.addDate = addDate;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return "Message(type=" + (Object)((Object)this.getType()) + ", createDate=" + this.getCreateDate() + ", addDate=" + this.getAddDate() + ", personId=" + this.getPersonId() + ", text=" + this.getText() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContentType this$type = this.getType();
        ContentType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        LocalDateTime this$createDate = this.getCreateDate();
        LocalDateTime other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        LocalDateTime this$addDate = this.getAddDate();
        LocalDateTime other$addDate = other.getAddDate();
        if (this$addDate == null ? other$addDate != null : !((Object)this$addDate).equals(other$addDate)) {
            return false;
        }
        Long this$personId = this.getPersonId();
        Long other$personId = other.getPersonId();
        if (this$personId == null ? other$personId != null : !((Object)this$personId).equals(other$personId)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ContentType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        LocalDateTime $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        LocalDateTime $addDate = this.getAddDate();
        result = result * 59 + ($addDate == null ? 43 : ((Object)$addDate).hashCode());
        Long $personId = this.getPersonId();
        result = result * 59 + ($personId == null ? 43 : ((Object)$personId).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }
}

