/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.domain.keyboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sadtech.social.core.domain.keyboard.KeyBoardLine;

public class KeyBoard {
    private List<KeyBoardLine> keyBoardLines = new ArrayList<KeyBoardLine>();
    private boolean oneTime = true;

    KeyBoard(List<KeyBoardLine> keyBoardLines, boolean oneTime) {
        this.keyBoardLines = keyBoardLines;
        this.oneTime = oneTime;
    }

    public static KeyBoardBuilder builder() {
        return new KeyBoardBuilder();
    }

    public List<KeyBoardLine> getKeyBoardLines() {
        return this.keyBoardLines;
    }

    public boolean isOneTime() {
        return this.oneTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyBoard)) {
            return false;
        }
        KeyBoard other = (KeyBoard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<KeyBoardLine> this$keyBoardLines = this.getKeyBoardLines();
        List<KeyBoardLine> other$keyBoardLines = other.getKeyBoardLines();
        if (this$keyBoardLines == null ? other$keyBoardLines != null : !((Object)this$keyBoardLines).equals(other$keyBoardLines)) {
            return false;
        }
        return this.isOneTime() == other.isOneTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyBoard;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<KeyBoardLine> $keyBoardLines = this.getKeyBoardLines();
        result = result * 59 + ($keyBoardLines == null ? 43 : ((Object)$keyBoardLines).hashCode());
        result = result * 59 + (this.isOneTime() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "KeyBoard(keyBoardLines=" + this.getKeyBoardLines() + ", oneTime=" + this.isOneTime() + ")";
    }

    public static class KeyBoardBuilder {
        private ArrayList<KeyBoardLine> keyBoardLines;
        private boolean oneTime;

        KeyBoardBuilder() {
        }

        public KeyBoardBuilder lineKeyBoard(KeyBoardLine lineKeyBoard) {
            if (this.keyBoardLines == null) {
                this.keyBoardLines = new ArrayList();
            }
            this.keyBoardLines.add(lineKeyBoard);
            return this;
        }

        public KeyBoardBuilder keyBoardLines(Collection<? extends KeyBoardLine> keyBoardLines) {
            if (this.keyBoardLines == null) {
                this.keyBoardLines = new ArrayList();
            }
            this.keyBoardLines.addAll(keyBoardLines);
            return this;
        }

        public KeyBoardBuilder clearKeyBoardLines() {
            if (this.keyBoardLines != null) {
                this.keyBoardLines.clear();
            }
            return this;
        }

        public KeyBoardBuilder oneTime(boolean oneTime) {
            this.oneTime = oneTime;
            return this;
        }

        public KeyBoard build() {
            List<KeyBoardLine> keyBoardLines;
            switch (this.keyBoardLines == null ? 0 : this.keyBoardLines.size()) {
                case 0: {
                    keyBoardLines = Collections.emptyList();
                    break;
                }
                case 1: {
                    keyBoardLines = Collections.singletonList(this.keyBoardLines.get(0));
                    break;
                }
                default: {
                    keyBoardLines = Collections.unmodifiableList(new ArrayList<KeyBoardLine>(this.keyBoardLines));
                }
            }
            return new KeyBoard(keyBoardLines, this.oneTime);
        }

        public String toString() {
            return "KeyBoard.KeyBoardBuilder(keyBoardLines=" + this.keyBoardLines + ", oneTime=" + this.oneTime + ")";
        }
    }
}

