/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.domain.keyboard.button;

import org.sadtech.social.core.domain.keyboard.ButtonColor;
import org.sadtech.social.core.domain.keyboard.ButtonType;
import org.sadtech.social.core.domain.keyboard.KeyBoardButton;

public class KeyBoardButtonText
extends KeyBoardButton {
    private String label;
    private ButtonColor color;

    private KeyBoardButtonText(String payload, String label, ButtonColor color) {
        super(payload, ButtonType.TEXT);
        this.label = label;
        this.color = color != null ? color : ButtonColor.DEFAULT;
    }

    public static KeyBoardButtonText of(String label) {
        return KeyBoardButtonText.builder().label(label).build();
    }

    public static KeyBoardButtonTextBuilder builder() {
        return new KeyBoardButtonTextBuilder();
    }

    public String getLabel() {
        return this.label;
    }

    public ButtonColor getColor() {
        return this.color;
    }

    @Override
    public String toString() {
        return "KeyBoardButtonText(label=" + this.getLabel() + ", color=" + (Object)((Object)this.getColor()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyBoardButtonText)) {
            return false;
        }
        KeyBoardButtonText other = (KeyBoardButtonText)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        ButtonColor this$color = this.getColor();
        ButtonColor other$color = other.getColor();
        return !(this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KeyBoardButtonText;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        ButtonColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
        return result;
    }

    public static class KeyBoardButtonTextBuilder {
        private String payload;
        private String label;
        private ButtonColor color;

        KeyBoardButtonTextBuilder() {
        }

        public KeyBoardButtonTextBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public KeyBoardButtonTextBuilder label(String label) {
            this.label = label;
            return this;
        }

        public KeyBoardButtonTextBuilder color(ButtonColor color) {
            this.color = color;
            return this;
        }

        public KeyBoardButtonText build() {
            return new KeyBoardButtonText(this.payload, this.label, this.color);
        }

        public String toString() {
            return "KeyBoardButtonText.KeyBoardButtonTextBuilder(payload=" + this.payload + ", label=" + this.label + ", color=" + (Object)((Object)this.color) + ")";
        }
    }
}

