/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.repository.impl.jpa;

import java.time.LocalDateTime;
import java.util.List;
import lombok.NonNull;
import org.sadtech.social.core.domain.content.Mail;
import org.sadtech.social.core.repository.ContentRepository;
import org.sadtech.social.core.repository.jpa.MailRepositoryJpa;

public class MailRepositoryJpaImpl
implements ContentRepository<Mail> {
    private final MailRepositoryJpa mailRepositoryJpa;

    @Override
    public Mail add(@NonNull Mail content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return (Mail)this.mailRepositoryJpa.saveAndFlush(content);
    }

    @Override
    public List<Mail> betweenByCreateDateTime(@NonNull LocalDateTime dateFrom, @NonNull LocalDateTime dateTo) {
        if (dateFrom == null) {
            throw new NullPointerException("dateFrom is marked non-null but is null");
        }
        if (dateTo == null) {
            throw new NullPointerException("dateTo is marked non-null but is null");
        }
        return this.mailRepositoryJpa.findByCreateDateBetween(dateFrom, dateTo);
    }

    @Override
    public List<Mail> betweenByAddDateTime(@NonNull LocalDateTime dateFrom, @NonNull LocalDateTime dateTo) {
        if (dateFrom == null) {
            throw new NullPointerException("dateFrom is marked non-null but is null");
        }
        if (dateTo == null) {
            throw new NullPointerException("dateTo is marked non-null but is null");
        }
        return this.mailRepositoryJpa.findByAddDateBetween(dateFrom, dateTo);
    }

    @Override
    public void deleteAllByAddDateBetween(@NonNull LocalDateTime dateFrom, @NonNull LocalDateTime dateTo) {
        if (dateFrom == null) {
            throw new NullPointerException("dateFrom is marked non-null but is null");
        }
        if (dateTo == null) {
            throw new NullPointerException("dateTo is marked non-null but is null");
        }
        this.mailRepositoryJpa.deleteAllByAddDateBetween(dateFrom, dateTo);
    }

    @Override
    public void deleteAllByAddDateBefore(@NonNull LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.mailRepositoryJpa.deleteAllByAddDateBefore(date);
    }

    @Override
    public void deleteAllByAddDateAfter(@NonNull LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.mailRepositoryJpa.deleteAllByAddDateAfter(date);
    }

    public MailRepositoryJpaImpl(MailRepositoryJpa mailRepositoryJpa) {
        this.mailRepositoryJpa = mailRepositoryJpa;
    }
}

