/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.repository.impl.local;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.sadtech.social.core.domain.money.Account;
import org.sadtech.social.core.repository.AccountRepository;

public class AccountRepositoryMap
implements AccountRepository {
    private final Map<Integer, Account> saveMap = new HashMap<Integer, Account>();
    private int id = 1;

    @Override
    public Account save(@NonNull Account account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (this.existsById(account.getId())) {
            account.setId(this.id);
            return this.saveMap.put(this.id++, account);
        }
        return this.saveMap.put(this.id, account);
    }

    @Override
    public Optional<Account> findById(@NonNull Integer accountId) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        return Optional.ofNullable(this.saveMap.get(accountId));
    }

    @Override
    public boolean existsById(Integer id) {
        return !this.saveMap.containsKey(id);
    }
}

