/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.repository.impl.local;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.sadtech.social.core.domain.content.Mail;
import org.sadtech.social.core.repository.ContentRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailRepositoryList
implements ContentRepository<Mail> {
    private static final Logger log = LoggerFactory.getLogger(MailRepositoryList.class);
    private final List<Mail> mails = new ArrayList<Mail>();
    private Long count = 0L;

    @Override
    public Mail add(Mail mail) {
        Long l = this.count;
        Long l2 = this.count = Long.valueOf(this.count + 1L);
        mail.setId(l);
        this.mails.add(mail);
        return mail;
    }

    @Override
    public List<Mail> betweenByCreateDateTime(@NonNull LocalDateTime dateFrom, @NonNull LocalDateTime dateTo) {
        if (dateFrom == null) {
            throw new NullPointerException("dateFrom is marked non-null but is null");
        }
        if (dateTo == null) {
            throw new NullPointerException("dateTo is marked non-null but is null");
        }
        ArrayList<Mail> rezultMails = new ArrayList<Mail>();
        for (int i = this.mails.size() - 1; i >= 0; --i) {
            Mail mail = this.mails.get(i);
            if (this.isTimePeriod(dateFrom, dateTo, mail.getAddDate())) {
                rezultMails.add(mail);
                continue;
            }
            if (mail.getCreateDate().isBefore(dateFrom)) break;
        }
        return rezultMails;
    }

    @Override
    public List<Mail> betweenByAddDateTime(@NonNull LocalDateTime dateFrom, @NonNull LocalDateTime dateTo) {
        if (dateFrom == null) {
            throw new NullPointerException("dateFrom is marked non-null but is null");
        }
        if (dateTo == null) {
            throw new NullPointerException("dateTo is marked non-null but is null");
        }
        ArrayList<Mail> rezultMails = new ArrayList<Mail>();
        for (int i = this.mails.size() - 1; i >= 0; --i) {
            Mail mail = this.mails.get(i);
            LocalDateTime addDate = mail.getAddDate();
            if (this.isTimePeriod(dateFrom, dateTo, addDate)) {
                rezultMails.add(mail);
                continue;
            }
            if (addDate.isBefore(dateFrom)) break;
        }
        return rezultMails;
    }

    @Override
    public void deleteAllByAddDateBetween(@NonNull LocalDateTime dateFrom, @NonNull LocalDateTime dateTo) {
        if (dateFrom == null) {
            throw new NullPointerException("dateFrom is marked non-null but is null");
        }
        if (dateTo == null) {
            throw new NullPointerException("dateTo is marked non-null but is null");
        }
        this.mails.removeIf(mail -> dateFrom.isBefore(mail.getAddDate()) && dateTo.isAfter(mail.getAddDate()));
    }

    @Override
    public void deleteAllByAddDateBefore(LocalDateTime date) {
        this.mails.removeIf(mail -> date.isBefore(mail.getAddDate()));
    }

    @Override
    public void deleteAllByAddDateAfter(LocalDateTime date) {
        this.mails.removeIf(mail -> date.isAfter(mail.getAddDate()));
    }

    private boolean isTimePeriod(@NonNull LocalDateTime dateFrom, @NonNull LocalDateTime dateTo, @NonNull LocalDateTime dateTime) {
        if (dateFrom == null) {
            throw new NullPointerException("dateFrom is marked non-null but is null");
        }
        if (dateTo == null) {
            throw new NullPointerException("dateTo is marked non-null but is null");
        }
        if (dateTime == null) {
            throw new NullPointerException("dateTime is marked non-null but is null");
        }
        return dateFrom.isBefore(dateTime) && dateTo.isAfter(dateTime);
    }
}

