/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.service.impl;

import lombok.NonNull;
import org.sadtech.social.core.domain.money.Account;
import org.sadtech.social.core.domain.money.AccountStatus;
import org.sadtech.social.core.exception.AccessException;
import org.sadtech.social.core.exception.NotFoundException;
import org.sadtech.social.core.exception.PaymentException;
import org.sadtech.social.core.repository.AccountRepository;
import org.sadtech.social.core.service.AccountService;

public class AccountServiceImpl
implements AccountService {
    private final AccountRepository accountRepository;

    @Override
    public Account add(@NonNull Account account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (this.accountRepository.existsById(account.getId())) {
            account.setAccountStatus(AccountStatus.EXPOSED);
            return this.accountRepository.save(account);
        }
        throw new AccessException("\u0421\u0447\u0435\u0442 " + account.getId() + " \u0443\u0436\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0431\u0430\u0437\u0435");
    }

    @Override
    public boolean pay(@NonNull Integer accountId, @NonNull Integer extinguishedPersonId, @NonNull Integer sum) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (extinguishedPersonId == null) {
            throw new NullPointerException("extinguishedPersonId is marked non-null but is null");
        }
        if (sum == null) {
            throw new NullPointerException("sum is marked non-null but is null");
        }
        Account account = this.accountRepository.findById(accountId).orElseThrow(() -> new NotFoundException("\u0421\u0447\u0435\u0442 " + accountId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d"));
        if (this.validStatus(account.getAccountStatus())) {
            if (!account.getTotalSum().equals(sum)) {
                account.setAccountStatus(AccountStatus.EXCEPTION);
                this.accountRepository.save(account);
                throw new PaymentException("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
            }
        } else {
            throw new PaymentException("\u0421\u0447\u0435\u0442 \u0443\u0436\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d");
        }
        account.setAccountStatus(AccountStatus.CLOSED);
        account.setExtinguishedPersonId(extinguishedPersonId);
        this.accountRepository.save(account);
        return true;
    }

    private boolean validStatus(@NonNull AccountStatus accountStatus) {
        if (accountStatus == null) {
            throw new NullPointerException("accountStatus is marked non-null but is null");
        }
        return AccountStatus.EXCEPTION.equals((Object)accountStatus) || AccountStatus.EXPOSED.equals((Object)accountStatus);
    }

    @Override
    public boolean paymentVerification(@NonNull Integer accountId) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        return AccountStatus.CLOSED.equals((Object)this.accountRepository.findById(accountId).orElseThrow(() -> new NotFoundException("\u0421\u0447\u0435\u0442 " + accountId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")).getAccountStatus());
    }

    public AccountServiceImpl(AccountRepository accountRepository) {
        this.accountRepository = accountRepository;
    }
}

