/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.service.impl;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import lombok.NonNull;
import org.sadtech.social.core.domain.content.Mail;
import org.sadtech.social.core.repository.ContentRepository;
import org.sadtech.social.core.service.MailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServiceImpl
implements MailService {
    private static final Logger log = LoggerFactory.getLogger(MailServiceImpl.class);
    private final ContentRepository<Mail> mailRepository;
    private boolean newMessage = false;
    private LocalDateTime oldDateTime = LocalDateTime.now(Clock.tickSeconds(ZoneId.systemDefault()));

    @Override
    public void add(Mail mail) {
        this.mailRepository.add(mail);
        this.newMessage = true;
        log.trace("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u0432 \u0440\u0435\u043f\u043e\u0437\u0438\u0442\u043e\u0440\u0438\u0439 | {}", (Object)mail);
    }

    @Override
    public List<Mail> getByAddDateTime(LocalDateTime timeFrom, LocalDateTime timeTo) {
        log.trace("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u044b \u0432\u0441\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f {} - {} ", (Object)timeFrom, (Object)timeTo);
        return this.mailRepository.betweenByAddDateTime(timeFrom, timeTo);
    }

    @Override
    public List<Mail> getLastEventByCreateDateTime(LocalDateTime timeFrom, LocalDateTime timeTo) {
        log.trace("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f {} - {} ", (Object)timeFrom, (Object)timeTo);
        List<Mail> mails = this.mailRepository.betweenByCreateDateTime(timeFrom, timeTo);
        if (mails != null && !mails.isEmpty()) {
            return this.getReturnMails(mails);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Mail> getLastEventByAddDateTime(LocalDateTime timeFrom, LocalDateTime timeTo) {
        log.trace("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f {} - {} ", (Object)timeFrom, (Object)timeTo);
        List<Mail> mails = this.mailRepository.betweenByAddDateTime(timeFrom, timeTo);
        if (mails != null && !mails.isEmpty()) {
            return this.getReturnMails(mails);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Mail> getNewMessage() {
        LocalDateTime newData = LocalDateTime.now(Clock.tickSeconds(ZoneId.systemDefault())).plusNanos(999999999L);
        List<Mail> lastEventByAddDateTime = Collections.emptyList();
        if (this.newMessage) {
            lastEventByAddDateTime = this.getLastEventByAddDateTime(this.oldDateTime, newData);
            this.newMessage = false;
            this.oldDateTime = newData;
        }
        return lastEventByAddDateTime;
    }

    @Override
    public void deleteAllByAddDateBetween(@NonNull LocalDateTime dateFrom, @NonNull LocalDateTime dateTo) {
        if (dateFrom == null) {
            throw new NullPointerException("dateFrom is marked non-null but is null");
        }
        if (dateTo == null) {
            throw new NullPointerException("dateTo is marked non-null but is null");
        }
        this.mailRepository.deleteAllByAddDateBetween(dateFrom, dateTo);
    }

    @Override
    public void deleteAllByAddDateBefore(@NonNull LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.mailRepository.deleteAllByAddDateBefore(date);
    }

    @Override
    public void deleteAllByAddDateAfter(@NonNull LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.mailRepository.deleteAllByAddDateAfter(date);
    }

    private List<Mail> getReturnMails(List<Mail> mails) {
        HashSet<Long> people = new HashSet<Long>();
        ArrayList<Mail> returnMails = new ArrayList<Mail>();
        for (int i = mails.size() - 1; i >= 0; --i) {
            if (people.contains(mails.get(i).getPersonId())) continue;
            returnMails.add(mails.get(i));
            people.add(mails.get(i).getPersonId());
        }
        if (!returnMails.isEmpty()) {
            return returnMails;
        }
        return Collections.emptyList();
    }

    public MailServiceImpl(ContentRepository<Mail> mailRepository) {
        this.mailRepository = mailRepository;
    }
}

