/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.service.sender.email;

import java.util.Properties;

public class EmailConfig {
    private Properties props = new Properties();
    private String username;
    private String password;

    private EmailConfig() {
    }

    public static Builder builder() {
        EmailConfig emailConfig = new EmailConfig();
        emailConfig.getClass();
        return emailConfig.new Builder();
    }

    public Properties getProps() {
        return this.props;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public class Builder {
        private Builder() {
        }

        public Builder smtpHost(String smtpHost) {
            EmailConfig.this.props.setProperty("mail.smtp.host", smtpHost);
            return this;
        }

        public Builder smtpSocketFactoryPort(Integer smtpSocketFactoryPortort) {
            EmailConfig.this.props.setProperty("mail.smtp.socketFactory.port", smtpSocketFactoryPortort.toString());
            return this;
        }

        public Builder smtpSocketFactoryClass(String smtpSocketFactoryClass) {
            EmailConfig.this.props.setProperty("mail.smtp.socketFactory.class", smtpSocketFactoryClass);
            return this;
        }

        public Builder smtpAuth(Boolean smtpAuth) {
            EmailConfig.this.props.setProperty("mail.smtp.auth", smtpAuth != false ? "true" : "false");
            return this;
        }

        public Builder smtpPort(Integer smtpPort) {
            EmailConfig.this.props.setProperty("mail.smtp.port", smtpPort.toString());
            return this;
        }

        public Builder email(String username) {
            EmailConfig.this.username = username;
            return this;
        }

        public Builder password(String password) {
            EmailConfig.this.password = password;
            return this;
        }

        public EmailConfig build() {
            return EmailConfig.this;
        }
    }
}

