/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.service.sender.email;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import lombok.NonNull;
import org.sadtech.social.core.domain.BoxAnswer;
import org.sadtech.social.core.exception.MailSendException;
import org.sadtech.social.core.service.sender.SendType;
import org.sadtech.social.core.service.sender.Sending;
import org.sadtech.social.core.service.sender.email.EmailConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSending
implements Sending {
    private static final Logger log = LoggerFactory.getLogger(EmailSending.class);
    private final EmailConfig emailConfig;

    @Override
    public void send(@NonNull Long personId, @NonNull BoxAnswer boxAnswer) {
        if (personId == null) {
            throw new NullPointerException("personId is marked non-null but is null");
        }
        if (boxAnswer == null) {
            throw new NullPointerException("boxAnswer is marked non-null but is null");
        }
        Session session = Session.getDefaultInstance((Properties)this.emailConfig.getProps(), (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EmailSending.this.emailConfig.getUsername(), EmailSending.this.emailConfig.getPassword());
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.emailConfig.getUsername()));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.emailConfig.getUsername()));
            message.setContent((Object)boxAnswer.getMessage(), "text/html; charset=utf-8");
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            log.error(e.getMessage());
            throw new MailSendException();
        }
    }

    @Override
    public void send(@NonNull Long contentId, @NonNull Long personId, @NonNull BoxAnswer boxAnswer) {
        if (contentId == null) {
            throw new NullPointerException("contentId is marked non-null but is null");
        }
        if (personId == null) {
            throw new NullPointerException("personId is marked non-null but is null");
        }
        if (boxAnswer == null) {
            throw new NullPointerException("boxAnswer is marked non-null but is null");
        }
        throw new MailSendException();
    }

    @Override
    public SendType getType() {
        return SendType.PUBLIC;
    }

    public EmailSending(EmailConfig emailConfig) {
        this.emailConfig = emailConfig;
    }
}

