/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.social.core.utils;

import java.util.Arrays;
import java.util.List;
import org.sadtech.social.core.domain.keyboard.ButtonColor;
import org.sadtech.social.core.domain.keyboard.KeyBoard;
import org.sadtech.social.core.domain.keyboard.KeyBoardButton;
import org.sadtech.social.core.domain.keyboard.KeyBoardLine;
import org.sadtech.social.core.domain.keyboard.button.KeyBoardButtonText;

public class KeyBoards {
    private KeyBoards() {
        throw new IllegalStateException();
    }

    public static KeyBoard keyBoardYesNo() {
        KeyBoardButtonText yesButton = KeyBoardButtonText.builder().color(ButtonColor.POSITIVE).label("\u0414\u0430").payload("{\"button\": \"yes\"}").build();
        KeyBoardButtonText noButton = KeyBoardButtonText.builder().color(ButtonColor.NEGATIVE).label("\u041d\u0435\u0442").payload("{\"button\": \"no\"}").build();
        KeyBoardLine keyBoardLine = KeyBoardLine.builder().buttonKeyBoard(yesButton).buttonKeyBoard(noButton).build();
        return KeyBoard.builder().lineKeyBoard(keyBoardLine).oneTime(true).build();
    }

    public static KeyBoard verticalMenuString(List<String> labelButtons) {
        KeyBoard.KeyBoardBuilder keyBoard = KeyBoard.builder().oneTime(true);
        for (String labelButton : labelButtons) {
            KeyBoardButtonText keyBoardButton = KeyBoardButtonText.builder().label(labelButton).payload("{\"button\": \"" + labelButton + "\"}").build();
            keyBoard.lineKeyBoard(KeyBoardLine.builder().buttonKeyBoard(keyBoardButton).build());
        }
        return keyBoard.build();
    }

    public static KeyBoard verticalMenuString(String ... labelButton) {
        return KeyBoards.verticalMenuString(Arrays.asList(labelButton));
    }

    public static KeyBoard verticalDuoMenuString(String ... labelButton) {
        return KeyBoards.verticalDuoMenuString(Arrays.asList(labelButton));
    }

    public static KeyBoard verticalDuoMenuString(List<String> labelButton) {
        KeyBoard.KeyBoardBuilder keyBoard = KeyBoard.builder().oneTime(true);
        boolean flag = true;
        KeyBoardLine.KeyBoardLineBuilder keyBoardLine = KeyBoardLine.builder();
        for (int i = 0; i <= labelButton.size() - 1; ++i) {
            String label = labelButton.get(i);
            if (flag) {
                keyBoardLine.buttonKeyBoard(KeyBoardButtonText.of(label));
                if (i == labelButton.size() - 1) {
                    keyBoard.lineKeyBoard(keyBoardLine.build());
                    continue;
                }
                flag = false;
                continue;
            }
            keyBoardLine.buttonKeyBoard(KeyBoardButtonText.of(label));
            keyBoard.lineKeyBoard(keyBoardLine.build());
            keyBoardLine = KeyBoardLine.builder();
            flag = true;
        }
        return keyBoard.build();
    }

    public static KeyBoard verticalMenuButton(List<KeyBoardButton> keyBoardButtons) {
        KeyBoard.KeyBoardBuilder keyBoard = KeyBoard.builder().oneTime(true);
        for (KeyBoardButton keyBoardButton : keyBoardButtons) {
            keyBoard.lineKeyBoard(KeyBoardLine.builder().buttonKeyBoard(keyBoardButton).build());
        }
        return keyBoard.build();
    }

    public static KeyBoard singelton(KeyBoardButton keyBoardButton) {
        KeyBoardLine line = KeyBoardLine.builder().buttonKeyBoard(keyBoardButton).build();
        return KeyBoard.builder().lineKeyBoard(line).build();
    }
}

