/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.generator.format;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.safris.xml.bind.generator.format.ClassModule;
import org.safris.xml.bind.generator.format.CloseBracketModule;
import org.safris.xml.bind.generator.format.DeclarationModule;
import org.safris.xml.bind.generator.format.DocumentationModule;
import org.safris.xml.bind.generator.format.FieldModule;
import org.safris.xml.bind.generator.format.FormatModule;
import org.safris.xml.bind.generator.format.ImportModule;
import org.safris.xml.bind.generator.format.MethodModule;
import org.safris.xml.bind.generator.format.OpenBracketModule;
import org.safris.xml.bind.generator.format.PackageModule;
import org.safris.xml.bind.generator.format.StatementModule;

public class SourceFormat {
    private List<FormatModule> modules = new LinkedList<FormatModule>();

    public static SourceFormat getDefaultFormat() {
        return new SourceFormat();
    }

    private SourceFormat() {
        this.addModule(new PackageModule());
        this.addModule(new DocumentationModule());
        this.addModule(new ImportModule());
        this.addModule(new MethodModule());
        this.addModule(new FieldModule());
        this.addModule(new ClassModule());
        this.addModule(new OpenBracketModule());
        this.addModule(new CloseBracketModule());
        this.addModule(new DeclarationModule());
        this.addModule(new StatementModule());
    }

    public void addModule(FormatModule module) {
        this.modules.add(module);
    }

    public String format(String unformated) {
        if (unformated == null) {
            return "";
        }
        FormatModule.restetDepth();
        String formated = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(unformated, "\t\n\r\f");
            String token = null;
            while (stringTokenizer.hasMoreTokens()) {
                token = stringTokenizer.nextToken();
                formated = this.modules(formated, token);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formated;
    }

    private String modules(String formated, String token) {
        String formatedToken = token;
        for (int i = 0; i < this.modules.size(); ++i) {
            FormatModule module = this.modules.get(i);
            token = module.format(formated, token);
            if (!formatedToken.equals(token)) {
                FormatModule.setLastModule(module);
                break;
            }
            formatedToken = token;
        }
        formated = formated + token;
        return formated;
    }
}

