/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.generator.lang;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.safris.xml.bind.runtime.lang.BindingError;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractGenerator {
    private static final ErrorHandler defaultErrorHandler = new ErrorHandler(){

        public void fatalError(SAXParseException exception) throws SAXException {
        }

        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXParseException {
            System.out.println("** Warning, line " + e.getLineNumber() + ", uri " + e.getSystemId());
            System.out.println("   " + e.getMessage());
        }
    };

    public static DocumentBuilder newDocumentBuilder() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(defaultErrorHandler);
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            String message = e.getMessage();
            BindingError bindingError = new BindingError(message != null ? message : "");
            bindingError.setStackTrace(e.getStackTrace());
            return null;
        }
    }
}

