/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.generator.lang;

public class ClassName {
    private final String _package;
    private final String _instance;
    private final String _name;
    private final AbstractedClass javaClass;

    public ClassName(String _package, String _name, boolean _abstract) {
        this._package = _package;
        this._name = _abstract ? "I" + ClassName.inTitleCase(_name) : ClassName.inTitleCase(_name);
        this._instance = _abstract ? "_i" + ClassName.inTitleCase(_name) : this.inLowerCase(_name);
        this.javaClass = null;
    }

    public ClassName(String _name, String _instance, String javaClass) {
        int i = _name.lastIndexOf(".");
        if (i != -1) {
            this._package = _name.substring(0, i);
            this._name = _name.substring(i + 1);
        } else {
            this._package = null;
            this._name = _name;
        }
        this._instance = _instance;
        this.javaClass = javaClass != null ? new AbstractedClass(javaClass) : null;
    }

    public AbstractedClass getJavaClass() {
        return this.javaClass;
    }

    public String getPackage() {
        return this._package;
    }

    public String getName() {
        if (this._package == null) {
            return this.getSimpleName();
        }
        return this._package + "." + this._name;
    }

    public String getSimpleName() {
        return this._name;
    }

    public String getInstanceName() {
        return this._instance;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassName)) {
            return false;
        }
        ClassName className = (ClassName)obj;
        return this._name.equals(className._name) && (this._package == null && className._package == null || this._package != null && this._package.equals(className._package));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private String inLowerCase(String string) {
        string = ClassName.javaCase(string);
        try {
            if (string.length() == 1) {
                return string.toLowerCase();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        int index = 0;
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            index = i;
            if ('0' <= chars[i] && chars[i] <= '9' || 'a' <= chars[i] && chars[i] <= 'z') break;
        }
        if (index == 1) {
            return "_" + string.substring(0, 1).toLowerCase() + string.substring(1, string.length());
        }
        if (index == string.length() - 1) {
            return "_" + string.toLowerCase();
        }
        if (index > 1) {
            return "_" + string.substring(0, index - 1).toLowerCase() + string.substring(index - 1, string.length());
        }
        return "_" + string;
    }

    private static String inTitleCase(String string) {
        if (string == null) {
            return null;
        }
        if ((string = ClassName.javaCase(string)).indexOf(".") != -1) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
    }

    private static String javaCase(String string) {
        if (string == null) {
            return null;
        }
        int index = string.indexOf("-");
        if (index != -1) {
            string = string.substring(0, index) + string.substring(index + 1, index + 2).toUpperCase() + string.substring(index + 2, string.length());
        }
        if ((index = string.indexOf(".")) != -1) {
            string = string.substring(0, index) + string.substring(index + 1, index + 2).toUpperCase() + string.substring(index + 2, string.length());
        }
        return string;
    }

    public static class AbstractedClass {
        private final String simpleName;
        private final String name;

        public AbstractedClass(String name) {
            if ("[B".equals(name)) {
                this.simpleName = "byte[]";
                this.name = "byte[]";
            } else {
                int index = name.lastIndexOf(".");
                this.simpleName = index != -1 ? name.substring(index + 1, name.length()) : name;
                this.name = name;
            }
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public String getName() {
            if ("[B".equals(this.name)) {
                return "byte[]";
            }
            return this.name;
        }
    }
}

