/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.generator.lang;

import java.io.File;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.safris.xml.bind.generator.format.SourceFormat;
import org.safris.xml.bind.generator.lang.AbstractGenerator;
import org.safris.xml.bind.generator.parse.ParseHandler;
import org.safris.xml.bind.runtime.lang.BindingError;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends AbstractGenerator {
    private static final Map<String, String> schemaToPackage = new HashMap<String, String>();
    private static final Map<String, String> namespaceToPackage = new HashMap<String, String>();
    private static SourceFormat format = null;
    private static File destDir = null;

    public static SourceFormat getFormat() {
        return format;
    }

    public static void putPackage(String namespaceURI, String _package) {
        namespaceToPackage.put(namespaceURI, _package);
    }

    public static String getPackage(String namespaceURI) {
        return namespaceToPackage.get(namespaceURI);
    }

    public static void main(String[] args) {
        if (args[0] == null) {
            return;
        }
        File destDir = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-bindings".equals(args[i]) && args.length > i - 1) {
                try {
                    File bindingsFile = new File(args[++i]);
                    if (!bindingsFile.exists()) {
                        Generator.exit("The bindings file \"" + bindingsFile.getPath() + "\" cannot be found.");
                    }
                    RandomAccessFile randomAccessFile = new RandomAccessFile(bindingsFile, "r");
                    String line = null;
                    while ((line = randomAccessFile.readLine()) != null) {
                        int index = line.indexOf("=");
                        if (index == -1) continue;
                        schemaToPackage.put(line.substring(0, index), line.substring(index + 1, line.length()));
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                    continue;
                }
            }
            if (!"-destdir".equals(args[i]) || args.length <= i - 1 || (destDir = new File(args[++i])).exists()) continue;
            Generator.exit("The destination directory \"" + destDir.getAbsolutePath() + "\" cannot be found.");
        }
        Generator.execute(destDir, schemaToPackage);
    }

    public static void execute(File destDir, Map<String, String> bindings) {
        Generator.destDir = destDir;
        format = SourceFormat.getDefaultFormat();
        try {
            DocumentBuilder documentBuilder = Generator.newDocumentBuilder();
            for (String schemaFile : bindings.keySet()) {
                Document document = documentBuilder.parse(schemaFile);
                String targetNamespace = document.getDocumentElement().getAttribute("targetNamespace");
                if (targetNamespace == null || targetNamespace.length() == 0) {
                    System.err.println("Schema in file " + schemaFile + " must define a targetNamespace.");
                    System.exit(1);
                }
                Generator.putPackage(targetNamespace, bindings.get(schemaFile));
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            BindingError bindingError = new BindingError(message != null ? message : "");
            bindingError.setStackTrace(e.getStackTrace());
        }
        for (String schema : bindings.keySet()) {
            URL url = null;
            File schemaFile = null;
            try {
                url = new URL(schema);
            }
            catch (MalformedURLException e) {
                try {
                    schemaFile = new File(schema);
                    url = new URL("file://" + schemaFile.getAbsolutePath());
                }
                catch (MalformedURLException ex) {
                    System.err.println("Unknown URL format: " + schema);
                    System.exit(1);
                }
            }
            ParseHandler root = new ParseHandler(){

                protected QName getName() {
                    return null;
                }

                protected void parse(Node node) {
                }

                public ParseHandler.Writer getWriter() {
                    return null;
                }
            };
            if (schemaFile != null) {
                root.setCwd(schemaFile.getParentFile());
            }
            System.out.println("Generatring source code for " + schema);
            ParseHandler.handle(null, root, url);
        }
    }

    public static File getDestDir() {
        return destDir;
    }

    private static void exit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println("Builder -binding [bindings-file] -destdir [directory]");
        System.exit(1);
    }
}

