/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.generator.parse;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.safris.xml.bind.generator.lang.AbstractGenerator;
import org.safris.xml.bind.generator.lang.ClassName;
import org.safris.xml.bind.generator.lang.Constants;
import org.safris.xml.bind.generator.parse.handler.ComplexTypeParser;
import org.safris.xml.bind.generator.parse.handler.ElementParser;
import org.safris.xml.bind.generator.parse.handler.SchemaParser;
import org.safris.xml.bind.generator.parse.handler.SimpleTypeParser;
import org.safris.xml.bind.generator.stage.StageHandler;
import org.safris.xml.bind.runtime.lang.BindingError;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParseHandler {
    private String documentation = "";
    private SchemaParser schema = null;
    private static final Map<QName, ElementParser> elementNodes = new HashMap<QName, ElementParser>();
    private static final Map<String, Class<ParseHandler>> handlers = new HashMap<String, Class<ParseHandler>>();
    private List<ParseHandler> children = new LinkedList<ParseHandler>();
    private ParseHandler parent = null;
    private String text = null;
    private ParseHandler previous = null;
    private ParseHandler next = null;
    private File cwd = null;

    public void addDocumentation(String text) {
        this.documentation = this.documentation + text;
    }

    public String getMetaDocumentation() {
        return " * @author Source generated with: <u>xml Bind for Java</u> by <b>Seva Safris &lt;seva@safris.org&gt;</b>\n";
    }

    public String getDocumentation() {
        if (this.documentation.trim().length() == 0) {
            return "\t/**\n" + this.getMetaDocumentation() + "*/\n";
        }
        this.documentation = this.documentation.replace("\t", " ");
        this.documentation = this.documentation.replace("\n\n", "^^^^");
        this.documentation = this.documentation.replace("\n", " ");
        this.documentation = this.documentation.replace("^^^^", "\n\n");
        String spaces = null;
        do {
            spaces = this.documentation;
            this.documentation = spaces.replace("  ", " ");
        } while (!this.documentation.equals(spaces));
        this.documentation = this.documentation.trim();
        String formatted = "\t/**\n";
        int start = 0;
        int end = 0;
        while ((end = this.documentation.indexOf(" ", end + 74)) != -1) {
            int temp = this.documentation.indexOf("\n", start);
            if (temp != -1 && temp < end) {
                end = temp;
            }
            formatted = formatted + "\t * " + this.documentation.substring(start, end) + "\n";
            start = end + 1;
        }
        return formatted + "\t * " + this.documentation.substring(start, this.documentation.length()) + "\n\n *\n" + this.getMetaDocumentation() + "\t */\n";
    }

    protected SchemaParser getSchema() {
        if (this.schema != null) {
            return this.schema;
        }
        ParseHandler handler = this.getParent();
        while (!((handler = handler.getParent()) instanceof SchemaParser)) {
        }
        this.schema = (SchemaParser)handler;
        return this.schema;
    }

    public void setCwd(File cwd) {
        this.cwd = cwd;
    }

    public File getCwd() {
        return this.cwd;
    }

    public void setPrevious(ParseHandler previous) {
        this.previous = previous;
    }

    public ParseHandler getPrevious() {
        return this.previous;
    }

    public void setNext(ParseHandler next) {
        this.next = next;
    }

    public ParseHandler getNext() {
        return this.next;
    }

    public static Map<QName, ElementParser> getElementNodes() {
        return elementNodes;
    }

    public void addChild(ParseHandler child) {
        this.children.add(child);
        child.parent = this;
    }

    public List<ParseHandler> getChildren() {
        return this.children;
    }

    protected void setParent(ParseHandler parent) {
        this.parent = parent;
    }

    public ParseHandler getParent() {
        return this.parent;
    }

    protected void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public static void handle(String targetNamespace, ParseHandler root, URL url) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = AbstractGenerator.newDocumentBuilder();
            document = documentBuilder.parse(url.toString());
        }
        catch (Exception e) {
            String message = e.getMessage();
            BindingError bindingError = new BindingError(message != null ? message : "");
            bindingError.setStackTrace(e.getStackTrace());
            throw bindingError;
        }
        root.recurse(0, targetNamespace, document.getChildNodes());
    }

    private ParseHandler recurse(int depth, String targetNamespace, NodeList children) {
        if (children == null || children.getLength() == 0) {
            return null;
        }
        ParseHandler schema = null;
        if (this instanceof SchemaParser) {
            schema = this;
            if (this.getTargetNamespace() == null) {
                ((SchemaParser)this).setTargetNamespace(targetNamespace);
            }
        }
        ++depth;
        ParseHandler current = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            Class<ParseHandler> cls = handlers.get(child.getLocalName());
            ParseHandler handler = null;
            try {
                if (cls == null) {
                    String elementName = child.getLocalName();
                    if (elementName == null && 3 == child.getNodeType()) {
                        if (child.getNodeValue().trim().length() == 0 || !this.getClass().getSimpleName().equalsIgnoreCase(child.getParentNode().getLocalName() + "Parser")) continue;
                        this.setText(child.getNodeValue());
                        continue;
                    }
                    elementName = elementName.substring(0, 1).toUpperCase() + elementName.substring(1, elementName.length());
                    String parseHandlerName = ParseHandler.class.getPackage().getName() + ".handler." + elementName + "Parser";
                    cls = Class.forName(parseHandlerName);
                    handlers.put(child.getLocalName(), cls);
                }
                handler = cls.newInstance();
            }
            catch (ClassNotFoundException e) {
                System.err.println("Class not found for parseHandler [" + child.getLocalName() + "]");
                System.exit(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.addChild(handler);
            if (current != null) {
                handler.setPrevious(current);
                current.setNext(handler);
            }
            current = handler;
            handler.registerElementName(child);
            handler.parse(child);
            handler.recurse(depth, targetNamespace, child.getChildNodes());
        }
        if (schema != null) {
            StageHandler.handle(schema);
        }
        return schema;
    }

    private void registerElementName(Node node) {
        if (!(this instanceof ElementParser)) {
            return;
        }
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeValue() == null || !"name".equals(attribute.getLocalName())) continue;
            QName name = new QName(this.getTargetNamespace(), attribute.getNodeValue());
            elementNodes.put(name, (ElementParser)this);
        }
    }

    public String getTargetNamespace() {
        ParseHandler handler = this.getParent();
        do {
            if (!(handler instanceof SchemaParser)) continue;
            return handler.getTargetNamespace();
        } while ((handler = handler.getParent()) != null);
        return null;
    }

    protected abstract QName getName();

    protected abstract void parse(Node var1);

    public QName parseQNameValue(Node attribute, Node parent) {
        String nodeValue = attribute.getNodeValue();
        int i = nodeValue.indexOf(":");
        if (i == -1) {
            Node xmlns = null;
            do {
                if (parent.getAttributes() != null) continue;
                return new QName(this.getTargetNamespace(), nodeValue);
            } while ((xmlns = parent.getAttributes().getNamedItem(Constants.XMLNS.getLocalPart())) == null && (parent = parent.getParentNode()) != null);
            if (xmlns == null) {
                System.err.println("Namespace problem");
                System.exit(1);
            }
            return new QName(xmlns.getNodeValue(), nodeValue);
        }
        String namespaceURI = null;
        String prefix = nodeValue.substring(0, i);
        namespaceURI = "xml".equals(prefix) ? "http://www.w3.org/XML/1998/namespace" : parent.lookupNamespaceURI(prefix);
        return new QName(namespaceURI, nodeValue.substring(i + 1, nodeValue.length()), prefix);
    }

    public abstract Writer getWriter();

    public abstract class Writer {
        private String classNameAsInner = null;

        public abstract ClassName getClassName();

        public abstract ClassName getTypeClassName();

        public abstract String getDeclaration();

        public abstract String getGetMethod();

        public abstract String getSetMethod();

        public abstract String getMarshalEntry();

        public abstract String getParseEntry();

        public abstract String getCopyEntry(String var1);

        public abstract String getEqualsEntry();

        public abstract String getHashCodeEntry();

        public abstract String getClassEntryAsInner();

        public abstract String getClassEntryAsOuter();

        public String getClassNameAsInner(String value) {
            if (this.classNameAsInner != null) {
                return this.classNameAsInner;
            }
            ParseHandler parent = ParseHandler.this.getParent();
            String name = "";
            String _package = null;
            while (!(parent instanceof SchemaParser)) {
                if (parent instanceof ComplexTypeParser && ((ComplexTypeParser)parent).getName() != null) {
                    name = ((ComplexTypeParser)parent).getWriter().getClassName().getSimpleName() + "." + name;
                    _package = ((ComplexTypeParser)parent).getWriter().getClassName().getPackage();
                } else if (parent instanceof SimpleTypeParser && ((SimpleTypeParser)parent).getName() != null) {
                    name = ((SimpleTypeParser)parent).getWriter().getClassName().getSimpleName() + "." + name;
                    _package = ((SimpleTypeParser)parent).getWriter().getClassName().getPackage();
                } else if (parent instanceof ElementParser && ((ElementParser)parent).getName() != null) {
                    name = ((ElementParser)parent).getWriter().getClassName().getSimpleName() + "." + name;
                    _package = ((ElementParser)parent).getWriter().getClassName().getPackage();
                }
                if ((parent = parent.getParent()) != null) continue;
            }
            name = name.length() != 0 ? _package + "." + name + value : value;
            this.classNameAsInner = name;
            return this.classNameAsInner;
        }
    }
}

