/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.generator.parse.handler;

import org.safris.xml.bind.generator.lang.ClassName;
import org.safris.xml.bind.generator.lang.Generator;
import org.safris.xml.bind.generator.parse.ParseHandler;
import org.safris.xml.bind.generator.parse.handler.AttributeParser;
import org.safris.xml.bind.generator.schema.attribute.Namespace;
import org.safris.xml.bind.generator.schema.attribute.ProcessContents;
import org.safris.xml.bind.runtime.lang.Attribute;
import org.safris.xml.bind.runtime.lang.Binding;
import org.safris.xml.bind.runtime.lang.CloneableList;
import org.safris.xml.bind.runtime.lang.SimpleType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AnyAttributeParser
extends AttributeParser {
    private Namespace _namespace = Namespace.ANY;
    private ProcessContents _processContents = ProcessContents.STRICT;
    private Writer writer = new Writer();

    public Namespace getNamespace() {
        return this._namespace;
    }

    public ProcessContents getProcessContents() {
        return this._processContents;
    }

    public void parse(Node node) {
        super.parse(node);
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeValue() == null) continue;
            if ("namespace".equals(attribute.getLocalName())) {
                this._namespace = Namespace.parseNamespace(attribute.getNodeValue());
                continue;
            }
            if (!"processContents".equals(attribute.getLocalName())) continue;
            this._processContents = ProcessContents.parseProcessContents(attribute.getNodeValue());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnyAttributeParser)) {
            return false;
        }
        AnyAttributeParser anyAttribute = (AnyAttributeParser)o;
        return this._namespace.equals(anyAttribute._namespace) && this._processContents.equals(anyAttribute._processContents);
    }

    public ParseHandler.Writer getWriter() {
        return this.writer;
    }

    public class Writer
    extends ParseHandler.Writer {
        private ClassName className;
        private String allowedClassName;

        public Writer() {
            super(AnyAttributeParser.this);
            this.className = null;
            this.allowedClassName = null;
        }

        public ClassName getClassName() {
            if (this.className == null) {
                this.className = new ClassName(Generator.getPackage(AnyAttributeParser.this.getName().getNamespaceURI()), AnyAttributeParser.this.getName().getLocalPart(), false);
            }
            return this.className;
        }

        public ClassName getTypeClassName() {
            return null;
        }

        public String getDeclaration() {
            return "private " + CloneableList.class.getName() + "<" + Binding.class.getName() + "<" + Attribute.class.getName() + ">," + Attribute.class.getName() + "> anyAttribute = null;\n";
        }

        public String getGetMethod() {
            StringBuffer out = new StringBuffer();
            out.append("public " + CloneableList.class.getName() + "<" + Binding.class.getName() + "<" + Attribute.class.getName() + ">," + Attribute.class.getName() + "> getANYATTR()\n");
            out.append("{\n");
            out.append("return anyAttribute;\n");
            out.append("}\n");
            return out.toString();
        }

        private String getAllowedClassName() {
            if (this.allowedClassName == null) {
                this.allowedClassName = Namespace.ANY.equals(AnyAttributeParser.this._namespace) || Namespace.OTHER.equals(AnyAttributeParser.this._namespace) ? SimpleType.class.getName() : (Namespace.LOCAL.equals(AnyAttributeParser.this._namespace) || Namespace.TARGETNAMESPACE.equals(AnyAttributeParser.this._namespace) ? this.getClassName().getPackage() + "." + "namespace" : Generator.getPackage(AnyAttributeParser.this._namespace.getValue()) + "." + "namespace");
            }
            return this.allowedClassName;
        }

        public String getSetMethod() {
            StringBuffer out = new StringBuffer();
            out.append("public void addANYATTR(" + Binding.class.getName() + "<" + Attribute.class.getName() + "> anyAttribute)\n");
            out.append("{\n");
            out.append("if(this.anyAttribute == null)\n");
            out.append("this.anyAttribute = new " + CloneableList.class.getName() + "<" + Binding.class.getName() + "<" + Attribute.class.getName() + ">," + Attribute.class.getName() + ">();\n");
            out.append("this.anyAttribute.add(anyAttribute);\n");
            out.append("}\n");
            return out.toString();
        }

        public String getMarshalEntry() {
            StringBuffer out = new StringBuffer();
            out.append("if(this.anyAttribute != null)\n");
            out.append("{\n");
            out.append("for(" + Binding.class.getName() + "<" + Attribute.class.getName() + "> anyAttribute : this.anyAttribute)\n");
            out.append("element.setAttributeNodeNS(" + Binding.class.getName() + ".marshalAttr(anyAttribute, " + Binding.class.getName() + "._getName(anyAttribute).getLocalPart(), element));\n");
            out.append("}\n");
            return out.toString();
        }

        public String getParseEntry() {
            StringBuffer out = new StringBuffer();
            out.append("else\n");
            out.append("{\n");
            out.append("if(this.anyAttribute == null)\n");
            out.append("this.anyAttribute = new " + CloneableList.class.getName() + "<" + Binding.class.getName() + "<" + Attribute.class.getName() + ">," + Attribute.class.getName() + ">();\n");
            out.append("this.anyAttribute.add(" + Binding.class.getName() + ".unmarshalAttr(element, attribute));\n");
            out.append("}\n");
            return out.toString();
        }

        public String getCopyEntry(String variable) {
            return "this.anyAttribute = " + variable + ".anyAttribute != null ? " + variable + ".anyAttribute.clone() : null;\n";
        }

        public String getEqualsEntry() {
            StringBuffer out = new StringBuffer();
            out.append("if((this.anyAttribute == null && binding.anyAttribute != null) || (this.anyAttribute != null && !this.anyAttribute.equals(binding.anyAttribute)))\n");
            out.append("return false;\n");
            return out.toString();
        }

        public String getHashCodeEntry() {
            return "stringBuffer.append(anyAttribute != null ? anyAttribute.hashCode() : 0).append(\"-\");\n";
        }

        public String getClassEntryAsInner() {
            return "";
        }

        public String getClassEntryAsOuter() {
            return "";
        }
    }
}

