/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.generator.parse.handler;

import org.safris.xml.bind.generator.lang.ClassName;
import org.safris.xml.bind.generator.lang.Elementable;
import org.safris.xml.bind.generator.lang.Generator;
import org.safris.xml.bind.generator.lang.Nameable;
import org.safris.xml.bind.generator.parse.ParseHandler;
import org.safris.xml.bind.generator.parse.handler.ElementParser;
import org.safris.xml.bind.generator.schema.attribute.Namespace;
import org.safris.xml.bind.generator.schema.attribute.ProcessContents;
import org.safris.xml.bind.runtime.lang.AnyType;
import org.safris.xml.bind.runtime.lang.Binding;
import org.safris.xml.bind.runtime.lang.Bindings;
import org.safris.xml.bind.runtime.lang.CloneableList;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AnyParser
extends ElementParser
implements Elementable,
Nameable {
    private Namespace _namespace = Namespace.ANY;
    private ProcessContents _processContents = ProcessContents.STRICT;
    private Writer writer = new Writer();

    public Namespace getNamespace() {
        return this._namespace;
    }

    public ProcessContents getProcessContents() {
        return this._processContents;
    }

    public void parse(Node node) {
        super.parse(node);
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeValue() == null) continue;
            if ("namespace".equals(attribute.getLocalName())) {
                this._namespace = Namespace.parseNamespace(attribute.getNodeValue());
                continue;
            }
            if (!"processContents".equals(attribute.getLocalName())) continue;
            this._processContents = ProcessContents.parseProcessContents(attribute.getNodeValue());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnyParser)) {
            return false;
        }
        AnyParser any = (AnyParser)o;
        return this._namespace.equals(any._namespace) && this._processContents.equals(any._processContents) && this._maxOccurs.equals(any._maxOccurs) && this._minOccurs.equals(any._minOccurs);
    }

    public ParseHandler.Writer getWriter() {
        return this.writer;
    }

    public class Writer
    extends ParseHandler.Writer {
        private ClassName className;
        private String allowedClassName;

        public Writer() {
            super(AnyParser.this);
            this.className = null;
            this.allowedClassName = null;
        }

        public ClassName getClassName() {
            if (this.className == null) {
                this.className = new ClassName(Generator.getPackage(AnyParser.this.getName().getNamespaceURI()), AnyParser.this.getName().getLocalPart(), false);
            }
            return this.className;
        }

        public ClassName getTypeClassName() {
            return null;
        }

        public String getDeclaration() {
            if (AnyParser.this._maxOccurs.getValue() > 1) {
                return "private " + CloneableList.class.getName() + "<" + this.getAllowedClassName() + "<" + AnyType.class.getName() + ">," + AnyType.class.getName() + "> any = null;\n";
            }
            return "private " + this.getAllowedClassName() + " any = null;\n";
        }

        public String getGetMethod() {
            StringBuffer out = new StringBuffer();
            if (AnyParser.this._maxOccurs.getValue() > 1) {
                out.append("public " + CloneableList.class.getName() + "<" + this.getAllowedClassName() + "<" + AnyType.class.getName() + ">," + AnyType.class.getName() + "> getANY()\n");
            } else {
                out.append("public " + Binding.class.getName() + " getANY()\n");
            }
            out.append("{\n");
            out.append("return any;\n");
            out.append("}\n");
            return out.toString();
        }

        private String getAllowedClassName() {
            if (this.allowedClassName == null) {
                this.allowedClassName = Namespace.ANY.equals(AnyParser.this._namespace) || Namespace.OTHER.equals(AnyParser.this._namespace) ? Binding.class.getName() : (Namespace.LOCAL.equals(AnyParser.this._namespace) || Namespace.TARGETNAMESPACE.equals(AnyParser.this._namespace) ? this.getClassName().getPackage() + "." + "namespace" : Generator.getPackage(AnyParser.this._namespace.getValue()) + "." + "namespace");
            }
            return this.allowedClassName;
        }

        public String getSetMethod() {
            StringBuffer out = new StringBuffer();
            if (AnyParser.this._maxOccurs.getValue() > 1) {
                out.append("public void addANY(" + this.getAllowedClassName() + " any)\n");
            } else {
                out.append("public void setANY(" + this.getAllowedClassName() + " any)\n");
            }
            out.append("{\n");
            if (AnyParser.this._maxOccurs.getValue() > 1) {
                out.append("if(this.any == null)\n");
                out.append("this.any = new " + CloneableList.class.getName() + "<" + this.getAllowedClassName() + "<" + AnyType.class.getName() + ">," + AnyType.class.getName() + ">();\n");
                out.append("this.any.add(any);\n");
            } else {
                out.append("this.any = any;\n");
            }
            out.append("}\n");
            return out.toString();
        }

        public String getMarshalEntry() {
            StringBuffer out = new StringBuffer();
            out.append("if(any != null)\n");
            out.append("{\n");
            if (AnyParser.this._maxOccurs.getValue() > 1) {
                out.append("for(" + this.getAllowedClassName() + " any : this.any)\n");
            }
            out.append("element.appendChild(" + Binding.class.getName() + ".marshal(element, any, " + Binding.class.getName() + "._getName(any), " + Binding.class.getName() + "._getTypeName(any)));\n");
            out.append("}\n");
            return out.toString();
        }

        public String getParseEntry() {
            StringBuffer out = new StringBuffer();
            out.append("else\n");
            out.append("{\n");
            if (AnyParser.this._maxOccurs.getValue() > 1) {
                out.append("if(this.any == null)\n");
                out.append("this.any = new " + CloneableList.class.getName() + "<" + this.getAllowedClassName() + "<" + AnyType.class.getName() + ">," + AnyType.class.getName() + ">();\n");
                out.append("this.any.add(" + Bindings.class.getName() + ".unmarshal((" + Element.class.getName() + ")childNode));\n");
            } else {
                out.append("this.any = " + Bindings.class.getName() + ".unmarshal((" + Element.class.getName() + ")childNode);\n");
            }
            out.append("element.removeChild(childNode);\n");
            out.append("i--;\n");
            out.append("}\n");
            return out.toString();
        }

        public String getCopyEntry(String variable) {
            return "this.any = " + variable + ".any != null ? " + variable + ".any.clone() : null;\n";
        }

        public String getEqualsEntry() {
            StringBuffer out = new StringBuffer();
            out.append("if((this.any == null && binding.any != null) || (this.any != null && !this.any.equals(binding.any)))\n");
            out.append("return false;\n");
            return out.toString();
        }

        public String getHashCodeEntry() {
            return "stringBuffer.append(any != null ? any.hashCode() : 0).append(\"-\");\n";
        }

        public String getClassEntryAsInner() {
            return "";
        }

        public String getClassEntryAsOuter() {
            return "";
        }
    }
}

