/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.generator.stage;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.safris.xml.bind.generator.lang.Beanable;
import org.safris.xml.bind.generator.lang.ClassName;
import org.safris.xml.bind.generator.lang.Generator;
import org.safris.xml.bind.generator.parse.ParseHandler;
import org.safris.xml.bind.generator.parse.handler.ComplexTypeParser;
import org.safris.xml.bind.generator.parse.handler.ElementParser;
import org.safris.xml.bind.generator.parse.handler.SchemaParser;
import org.safris.xml.bind.generator.parse.handler.SimpleTypeParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StageHandler<T extends ParseHandler> {
    private static final Map<String, StageHandler> handlers = new HashMap<String, StageHandler>();

    public static void handle(ParseHandler handler) {
        Method[] methods;
        StageHandler root = new StageHandler(){

            protected void stage1(ParseHandler handler) {
            }

            protected void stage2(ParseHandler handler) {
            }

            protected void stage3(ParseHandler handler) {
            }

            protected void stage4(ParseHandler handler) {
            }
        };
        int stages = 0;
        for (Method method : methods = root.getClass().getDeclaredMethods()) {
            if (!method.getName().startsWith("stage")) continue;
            ++stages;
        }
        for (int stage = 0; stage < stages; ++stage) {
            super.recurse(0, stage, handler.getChildren());
        }
        for (ParseHandler child : handler.getChildren()) {
            if (!(child instanceof Beanable) || child instanceof ElementParser && ((ElementParser)child).isInner() || child instanceof SimpleTypeParser && ((SimpleTypeParser)child).isInner()) continue;
            ParseHandler parent = handler;
            do {
                if (!(parent instanceof SchemaParser)) continue;
                parent = parent.getParent().getChildren().get(0);
                break;
            } while ((parent = parent.getParent()) != null);
            try {
                if (parent.getTargetNamespace() == null) {
                    System.err.println("Cannot generate classes for schema with no targetNamespace.");
                    System.exit(1);
                }
                if (!parent.getTargetNamespace().equals(child.getTargetNamespace())) continue;
                StageHandler.writeFile(child);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void recurse(int depth, int stage, List<ParseHandler> children) {
        try {
            if (children == null || children.size() == 0) {
                return;
            }
            ++depth;
            for (ParseHandler child : children) {
                StageHandler handler = handlers.get(child.getClass().getSimpleName());
                if (handler == null) {
                    String stageHandlerName = StageHandler.class.getPackage().getName() + ".handler." + child.getClass().getSimpleName().substring(0, child.getClass().getSimpleName().indexOf("Parser")) + "Stage";
                    try {
                        handler = (StageHandler)Class.forName(stageHandlerName).newInstance();
                        handlers.put(child.getClass().getSimpleName(), handler);
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Class not found for stageHandler [" + child.getClass().getSimpleName() + "]");
                        System.exit(1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Method method = null;
                try {
                    method = handler.getClass().getDeclaredMethod("stage" + (stage + 1), ParseHandler.class);
                    method.setAccessible(true);
                    method.invoke((Object)handler, child);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Uh oh");
                    System.exit(1);
                }
                handler.recurse(depth, stage, child.getChildren());
            }
            if (stage == 1) {
                ElementParser.fixMixed();
                ComplexTypeParser.fixMixed();
            }
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
    }

    private static void writeFile(ParseHandler handler) {
        ClassName name = handler.getWriter().getClassName();
        if (name == null) {
            return;
        }
        try {
            if (name.getPackage() == null) {
                System.err.println("The binding configuration does not specify package for " + handler.getTargetNamespace());
                System.exit(1);
            }
            File directory = new File(Generator.getDestDir() + File.separator + name.getPackage().replace('.', '/'));
            StageHandler.createDir(directory);
            File namespaceFile = new File(directory.getAbsolutePath() + File.separator + "namespace.java");
            if (!namespaceFile.exists()) {
                FileOutputStream out = new FileOutputStream(namespaceFile);
                String namespaceText = Generator.getFormat().format("package " + name.getPackage() + ";\npublic interface namespace\n{\n}");
                out.write(namespaceText.getBytes());
                out.flush();
                out.close();
            }
            String file = directory.getAbsolutePath() + File.separator + name.getSimpleName() + ".java";
            String text = Generator.getFormat().format(handler.getWriter().getClassEntryAsOuter());
            FileOutputStream out = new FileOutputStream(file);
            out.write(text.getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createDir(File directory) {
        StringTokenizer stringTokenizer = new StringTokenizer(directory.getPath(), "/\\", true);
        String token = "";
        File dir = null;
        while (stringTokenizer.hasMoreTokens()) {
            dir = new File(token = token + stringTokenizer.nextToken());
            if (dir.exists()) continue;
            dir.mkdir();
        }
    }

    protected abstract void stage1(T var1);

    protected abstract void stage2(T var1);

    protected abstract void stage3(T var1);

    protected abstract void stage4(T var1);
}

