/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.safris.xml.bind.runtime.lang.AbstractBinding;
import org.safris.xml.bind.runtime.lang.Attribute;
import org.safris.xml.bind.runtime.lang.BindingError;
import org.safris.xml.bind.runtime.lang.BindingException;
import org.safris.xml.bind.runtime.lang.BindingType;
import org.safris.xml.bind.runtime.lang.Bindings;
import org.safris.xml.bind.runtime.lang.CloneableList;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.QNameType;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Binding<T extends BindingType>
extends AbstractBinding {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    protected static DocumentBuilder newDocumentBuilder() {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String message = e.getMessage();
            BindingError bindingError = new BindingError(message != null ? message : "");
            bindingError.setStackTrace(e.getStackTrace());
        }
        return documentBuilder;
    }

    protected static Element createElementNS(String namespaceURI, String localName) {
        return Binding.newDocumentBuilder().getDOMImplementation().createDocument(namespaceURI, localName, null).getDocumentElement();
    }

    protected static String _getPrefix(Element parent, String namespaceURI) {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return null;
        }
        String prefix = (parent = parent.getOwnerDocument().getDocumentElement()).lookupPrefix(namespaceURI);
        if (prefix != null) {
            return prefix;
        }
        int i = 0;
        do {
            i = (short)(i + 1);
        } while (parent.lookupNamespaceURI("ns" + i) != null);
        prefix = "ns" + i;
        parent.setAttributeNS(XMLNS.getNamespaceURI(), XMLNS.getLocalPart() + ":" + prefix, namespaceURI);
        return prefix;
    }

    protected static CloneableList _parseAttrList(Class xmlClass, Element parent, Node node) {
        CloneableList list = new CloneableList();
        StringTokenizer stringTokenizer = new StringTokenizer(node.getNodeValue());
        try {
            if (QNameType.class.isAssignableFrom(xmlClass)) {
                Constructor constructor = xmlClass.getDeclaredConstructor(QName.class);
                constructor.setAccessible(true);
                while (stringTokenizer.hasMoreTokens()) {
                    QName qName = Binding.stringToQName(stringTokenizer.nextToken());
                    qName = new QName(parent.lookupNamespaceURI(qName.getPrefix()), qName.getLocalPart());
                    list.add((Binding)constructor.newInstance(qName));
                }
            } else {
                while (stringTokenizer.hasMoreTokens()) {
                    Constructor constructor = xmlClass.getDeclaredConstructor(String.class);
                    constructor.setAccessible(true);
                    list.add((Binding)constructor.newInstance(stringTokenizer.nextToken()));
                }
            }
        }
        catch (Exception e) {
            System.err.println(xmlClass.getName());
            e.printStackTrace();
            System.exit(1);
        }
        return list;
    }

    protected static Binding<Attribute> _parseAttr(Class xmlClass, Element parent, Node node) {
        try {
            if (QNameType.class.isAssignableFrom(xmlClass)) {
                QName qName = Binding.stringToQName(node.getNodeValue());
                qName = new QName(parent.getOwnerDocument().getDocumentElement().lookupNamespaceURI(qName.getPrefix()), qName.getLocalPart());
                Constructor constructor = xmlClass.getDeclaredConstructor(QName.class);
                constructor.setAccessible(true);
                return (Binding)constructor.newInstance(qName);
            }
            Constructor constructor = xmlClass.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            return (Binding)constructor.newInstance(node.getNodeValue());
        }
        catch (Exception e) {
            System.err.println(xmlClass.getName());
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Element element = parent;
        if (parent.getPrefix() != null) {
            element = parent.getOwnerDocument().createElementNS(name.getNamespaceURI(), name.getLocalPart());
        }
        element.setPrefix(Binding._getPrefix(parent, name.getNamespaceURI()));
        if (this._getTypeName() != null && !typeName.equals(this._getTypeName())) {
            String prefix = parent.getOwnerDocument().getDocumentElement().lookupPrefix(this._getTypeName().getNamespaceURI());
            parent.getOwnerDocument().getDocumentElement().setAttributeNS(XMLNS.getNamespaceURI(), "xmlns:" + TYPE.getPrefix(), TYPE.getNamespaceURI());
            element.setAttributeNS(XML.getNamespaceURI(), TYPE.getPrefix() + ":type", prefix + ":" + this._getTypeName().getLocalPart());
        }
        return element;
    }

    protected static Element marshal(Element parent, Binding binding, QName name, QName typeName) throws MarshalException {
        try {
            return binding.marshal(parent, name, typeName);
        }
        catch (Throwable e) {
            System.err.println("binding: " + binding);
            System.err.println("name: " + name);
            System.err.println("typeName: " + typeName);
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    protected static Attr marshalAttr(Binding<? extends Attribute> binding, String name, Element parent) {
        return binding.marshalAttr(name, parent);
    }

    protected static Attr marshalAttr(CloneableList<? extends Binding, ? extends Attribute> binding, String name, Element parent) {
        String value = "";
        for (Binding xmlSimpleType : binding) {
            value = value + " " + ((Object)xmlSimpleType).toString();
        }
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(value.length() != 0 ? value.substring(1) : "");
        return attr;
    }

    protected static void parse(Binding binding, Element element) throws UnmarshalException, ValidationException {
        binding.parse(element);
    }

    protected static QName _getName(Binding element) {
        return element._getName();
    }

    protected static QName _getTypeName(Binding binding) {
        return binding._getTypeName();
    }

    protected static Binding unmarshal(Element element, Class defaultClass, QName name) throws UnmarshalException, ValidationException {
        return Binding.unmarshalElement((Element)element.cloneNode(true), defaultClass, name);
    }

    protected static Binding<Attribute> unmarshalAttr(Element element, Node node) throws UnmarshalException {
        String nodeLocalName = node.getLocalName();
        String namespaceURI = node.getNamespaceURI();
        String classBinding = Binding.getElementBindings().get(new QName(namespaceURI, nodeLocalName));
        if (classBinding == null) {
            throw new UnmarshalException("Unable to find class binding for {" + namespaceURI + "}" + ":" + nodeLocalName);
        }
        try {
            return Binding._parseAttr(Class.forName(classBinding), element, node);
        }
        catch (Exception e) {
            throw new UnmarshalException(classBinding, e);
        }
    }

    protected static Binding unmarshalElement(Element element, Class defaultClass, QName name) throws UnmarshalException, ValidationException {
        String nodeLocalName = element.getLocalName();
        String namespaceURI = element.getNamespaceURI();
        String nodePrefix = element.getPrefix();
        NamedNodeMap rootAttributes = element.getAttributes();
        Node rootAttribute = null;
        String rootAttributeNamespaceURI = null;
        String rootAttributeLocalName = null;
        String rootAttributeValue = null;
        boolean xsiType = false;
        for (int i = 0; i < rootAttributes.getLength(); ++i) {
            rootAttribute = rootAttributes.item(i);
            rootAttributeNamespaceURI = rootAttribute.getNamespaceURI();
            rootAttributeLocalName = rootAttribute.getLocalName();
            rootAttributeValue = rootAttribute.getNodeValue();
            if (!TYPE.getNamespaceURI().equals(rootAttributeNamespaceURI) || !TYPE.getLocalPart().equals(rootAttributeLocalName)) continue;
            xsiType = true;
            nodeLocalName = Binding.parseLocalName(rootAttributeValue);
            nodePrefix = Binding.parsePrefix(rootAttributeValue);
            if (nodePrefix == null) {
                nodePrefix = XMLNS.getLocalPart();
            }
            namespaceURI = null;
        }
        Class<?> cls = null;
        try {
            Object method;
            if (defaultClass == null || xsiType) {
                namespaceURI = element.getOwnerDocument().getDocumentElement().lookupNamespaceURI(nodePrefix);
                String classBinding = null;
                classBinding = xsiType ? Binding.getTypeBindings().get(new QName(namespaceURI, nodeLocalName)) : Binding.getElementBindings().get(new QName(namespaceURI, nodeLocalName));
                if (classBinding == null) {
                    System.err.println("Unable to find class binding for {" + namespaceURI + "}" + ":" + nodeLocalName + " xsi:type = " + xsiType);
                    throw new UnmarshalException("Unable to find class binding for {" + namespaceURI + "}" + ":" + nodeLocalName);
                }
                cls = Class.forName(classBinding);
            } else {
                cls = defaultClass;
            }
            Binding binding = null;
            if (xsiType) {
                method = cls.getDeclaredMethod("newInstance", QName.class);
                ((Method)method).setAccessible(true);
                binding = (Binding)((Method)method).invoke(null, name);
            } else {
                binding = (Binding)cls.newInstance();
            }
            binding.parse(element);
            method = binding;
            return method;
        }
        catch (Exception e) {
            String message = e.getMessage() != null ? "\n" + e.getMessage() : "";
            UnmarshalException unmarshalException = new UnmarshalException(cls.getName() + message);
            unmarshalException.setStackTrace(e.getStackTrace());
            throw unmarshalException;
        }
    }

    protected Binding(Binding binding) {
    }

    protected Binding() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof Binding;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public Binding clone() {
        return null;
    }

    public String toString() {
        try {
            return Bindings.domToString(this.marshal());
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract QName _getName();

    protected QName _getTypeName() {
        return null;
    }

    protected Element marshal() throws MarshalException, ValidationException {
        Element root = Binding.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    protected void parse(Element element) throws UnmarshalException, ValidationException {
    }

    protected String[] _getPattern() {
        return null;
    }

    protected Object getTEXT() {
        return null;
    }

    protected Attr marshalAttr(String name, Element parent) {
        return null;
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
    }
}

