/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.lang;

import java.util.HashMap;
import java.util.Map;
import org.safris.xml.bind.runtime.lang.Binding;
import org.safris.xml.bind.runtime.lang.BindingConfig;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.PackageLoader;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.util.Validator;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class Bindings {
    private static final Map<ClassLoader, PackageLoader> packageLoaders = new HashMap<ClassLoader, PackageLoader>();
    private static boolean indent = false;

    protected static boolean getIndent() {
        return indent;
    }

    public static void bootstrapConfig(BindingConfig config) {
        indent = config.getIndent();
        String[] schemaPackages = config.getSchemaPackages();
        if (schemaPackages != null && schemaPackages.length > 0) {
            for (String schemaPackage : schemaPackages) {
                Bindings.bootstrapSchemaPackage(schemaPackage, Binding.class.getClassLoader());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bootstrapSchemaPackage(String schemaPackage, ClassLoader classLoader) {
        PackageLoader packageLoader = packageLoaders.get(classLoader);
        if (packageLoader == null) {
            Map<ClassLoader, PackageLoader> map = packageLoaders;
            synchronized (map) {
                packageLoader = packageLoaders.get(classLoader);
                if (packageLoader == null) {
                    packageLoader = new PackageLoader(classLoader);
                    packageLoaders.put(classLoader, packageLoader);
                }
            }
        }
        packageLoader.loadPackage(schemaPackage, classLoader);
    }

    public static String domToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        Bindings.domToString(stringBuffer, element, 0);
        return stringBuffer.toString();
    }

    private static void domToString(StringBuffer stringBuffer, Node node, int depth) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        String nodeName = node.getNodeName();
        String nodeValue = node.getNodeValue();
        if (type == 1) {
            if (Bindings.getIndent() && stringBuffer.length() > 1 && stringBuffer.charAt(stringBuffer.length() - 1) == '>') {
                stringBuffer.append("\n");
                for (int i = 0; i < depth; ++i) {
                    stringBuffer.append("\t");
                }
            }
            stringBuffer.append("<");
            stringBuffer.append(nodeName);
            Bindings.attributesToString(stringBuffer, node, depth + 1);
            if (node.hasChildNodes()) {
                int i;
                stringBuffer.append(">");
                NodeList nodeList = node.getChildNodes();
                for (i = 0; i < nodeList.getLength(); ++i) {
                    Bindings.domToString(stringBuffer, nodeList.item(i), depth + 1);
                }
                if (Bindings.getIndent() && stringBuffer.length() > 1 && stringBuffer.charAt(stringBuffer.length() - 1) == '>') {
                    stringBuffer.append("\n");
                    for (i = 0; i < depth; ++i) {
                        stringBuffer.append("\t");
                    }
                }
                stringBuffer.append("</").append(nodeName).append(">");
            } else {
                stringBuffer.append("/>");
            }
        } else if (3 == type && nodeValue != null && nodeValue.length() != 0) {
            Bindings.entityConvert(stringBuffer, nodeValue);
        }
    }

    private static void attributesToString(StringBuffer stringBuffer, Node node, int depth) {
        NamedNodeMap namedNodeMap = null;
        namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            String nodeName = null;
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                node = namedNodeMap.item(i);
                if (Bindings.getIndent()) {
                    stringBuffer.append("\n");
                    for (int j = 0; j < depth; ++j) {
                        stringBuffer.append("\t");
                    }
                } else {
                    stringBuffer.append(" ");
                }
                nodeName = node.getNodeName();
                stringBuffer.append(nodeName);
                stringBuffer.append("=\"");
                Bindings.entityConvert(stringBuffer, node.getNodeValue());
                stringBuffer.append("\"");
            }
        }
    }

    private static void entityConvert(StringBuffer stringBuffer, String entity) {
        if (entity == null) {
            return;
        }
        block5: for (int i = 0; i < entity.length(); ++i) {
            switch (entity.charAt(i)) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block5;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block5;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block5;
                }
                default: {
                    stringBuffer.append(entity.substring(i, i + 1));
                }
            }
        }
    }

    public static Element marshal(Binding element) throws MarshalException, ValidationException {
        return element.marshal();
    }

    public static Binding unmarshal(Element element) throws UnmarshalException, ValidationException {
        return Binding.unmarshalElement((Element)element.cloneNode(true), null, null);
    }

    public static Binding unmarshal(InputSource inputSource) throws UnmarshalException, ValidationException {
        Element element = null;
        try {
            element = Binding.newDocumentBuilder().parse(inputSource).getDocumentElement();
        }
        catch (Exception e) {
            String message = e.getMessage();
            UnmarshalException unmarshalException = new UnmarshalException(message != null ? message : "");
            unmarshalException.setStackTrace(e.getStackTrace());
            throw unmarshalException;
        }
        if (Validator.getSystemValidator() != null) {
            Validator.getSystemValidator().validateUnmarshal(element);
        }
        return Binding.unmarshalElement(element, null, null);
    }
}

