/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.lang;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.SecureClassLoader;
import org.safris.xml.bind.runtime.lang.Binding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoader
extends SecureClassLoader {
    private final java.lang.ClassLoader parent;

    public ClassLoader() {
        this.parent = null;
    }

    public ClassLoader(java.lang.ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findClass(name);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (Binding.class.getName().equals(name)) {
            if (this.parent != null) {
                return this.parent.loadClass(name);
            }
            return ClassLoader.getSystemClassLoader().loadClass(name);
        }
        String fileName = name;
        if (!(fileName = fileName.replace('.', '/')).startsWith("/")) {
            fileName = '/' + fileName;
        }
        fileName = fileName + ".class";
        URL url = ClassLoader.class.getResource("/");
        String decodedUrl = null;
        try {
            decodedUrl = URLDecoder.decode(url.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("ClassLoader: findClass(" + name + ")\n" + e.getMessage());
        }
        Class<?> bindingClass = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(decodedUrl + fileName, "r");
            byte[] bytes = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(bytes);
            randomAccessFile.close();
            bindingClass = this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (FileNotFoundException e) {
            Class<?> cls = null;
            cls = this.parent != null ? this.parent.loadClass(name) : ClassLoader.getSystemClassLoader().loadClass(name);
            return cls;
        }
        catch (IOException e) {
            System.err.println("ClassLoader: findClass(" + name + ")\n" + e.getMessage());
        }
        return bindingClass;
    }
}

