/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.lang;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class PackageLoader {
    private ClassLoader classLoader = null;

    private static void newInstance(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, true, classLoader);
        }
        catch (Throwable e) {
            System.err.println("PackageLoader: newInstance(" + className + ", " + classLoader + ")\n" + e.getMessage());
            System.exit(1);
        }
    }

    public PackageLoader() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public PackageLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public synchronized void loadPackage(String packageName, ClassLoader classLoader) {
        block12: {
            String name = null;
            name = packageName.startsWith("/") || packageName.startsWith(".") ? packageName.replace('.', '/') : '/' + packageName.replace('.', '/');
            URL url = PackageLoader.class.getResource(name);
            if (url == null) {
                return;
            }
            String decodedUrl = null;
            try {
                decodedUrl = URLDecoder.decode(url.getFile(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("PackageLoader: loadPackage(" + packageName + ", " + classLoader + ")\n" + e.getMessage());
            }
            File directory = new File(decodedUrl);
            try {
                if (directory.exists()) {
                    String[] files = directory.list();
                    String file = null;
                    String className = null;
                    for (int i = 0; i < files.length; ++i) {
                        file = files[i];
                        if (file.endsWith(".class")) {
                            className = file.substring(0, files[i].length() - 6);
                            PackageLoader.newInstance(packageName + "." + className, classLoader);
                            continue;
                        }
                        if (!new File(directory, file).isDirectory()) continue;
                        this.loadPackage(packageName + "." + file, classLoader);
                    }
                    break block12;
                }
                try {
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    String entryName = jarURLConnection.getEntryName();
                    JarFile jarFile = jarURLConnection.getJarFile();
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    String zipEntryName = null;
                    String className = null;
                    while (enumeration.hasMoreElements()) {
                        zipEntryName = ((ZipEntry)enumeration.nextElement()).getName();
                        if (!zipEntryName.startsWith(entryName) || zipEntryName.lastIndexOf(entryName + "/") > entryName.length() || !zipEntryName.endsWith(".class")) continue;
                        className = zipEntryName.substring(0, zipEntryName.length() - 6);
                        if (className.startsWith("/")) {
                            className = className.substring(1);
                        }
                        className = className.replace('/', '.');
                        PackageLoader.newInstance(className, classLoader);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            catch (AccessControlException e) {
                System.err.println("Unable to load package");
            }
        }
    }

    public void loadPackage(String packageName) {
        this.loadPackage(packageName, this.classLoader);
    }
}

