/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types;

import java.io.IOException;
import java.io.Serializable;
import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.BindingType;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.SimpleType;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.XSType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Base64BinaryType<T extends BindingType>
extends XSType<SimpleType>
implements Serializable {
    private String encoded = null;
    private byte[] decoded = null;

    protected static Base64BinaryType parse(String value) {
        return new Base64BinaryType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    protected static Base64BinaryType parse(byte[] value) {
        return new Base64BinaryType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    public Base64BinaryType(Base64BinaryType binding) {
        if (binding == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.encoded = binding.encoded;
        this.decoded = binding.decoded;
    }

    public Base64BinaryType(byte[] value) {
        this.decoded = value;
        this.encoded = new BASE64Encoder().encodeBuffer(value).trim();
    }

    public Base64BinaryType(String value) {
        super(value);
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        try {
            this.encoded = value.trim();
            this.decoded = new BASE64Decoder().decodeBuffer(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to decode", e);
        }
    }

    protected Base64BinaryType() {
    }

    protected byte[] getTEXT() {
        return this.decoded;
    }

    protected void setTEXT(byte[] text) {
        this.decoded = text;
    }

    @Override
    protected void parse(Element element) throws UnmarshalException, ValidationException {
        try {
            String value = "";
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeValue() == null) continue;
                value = value + nodeList.item(i).getNodeValue().trim();
            }
            if (value.length() == 0) {
                return;
            }
            this.encoded = value;
            this.decoded = new BASE64Decoder().decodeBuffer(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to decode", e);
        }
    }

    @Override
    protected Element marshal() throws MarshalException, ValidationException {
        Element root = Base64BinaryType.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    @Override
    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Document document = parent.getOwnerDocument();
        Element element = super.marshal(parent, name, typeName);
        element.appendChild(document.createTextNode(this.toString()));
        return element;
    }

    @Override
    protected Attr marshalAttr(String name, Element parent) {
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(this.toString());
        return attr;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Base64BinaryType)) {
            return false;
        }
        Base64BinaryType base64Binary = (Base64BinaryType)obj;
        return this.encoded == null && base64Binary.encoded == null || this.encoded.equals(base64Binary.encoded);
    }

    @Override
    public int hashCode() {
        return this.encoded.hashCode();
    }

    @Override
    public String toString() {
        if (this.encoded == null) {
            return "";
        }
        return this.encoded;
    }
}

