/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.BindingType;
import org.safris.xml.bind.runtime.lang.IllegalBindingException;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.SimpleType;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.XSType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BooleanType<T extends BindingType>
extends XSType<SimpleType> {
    private static final Map<Boolean, String[]> valueMap = new HashMap<Boolean, String[]>();
    private Boolean value = null;

    protected static BooleanType parse(String value) {
        return new BooleanType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    protected static BooleanType parse(Boolean value) {
        return new BooleanType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    public BooleanType(BooleanType binding) {
        if (binding == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.value = binding.value;
    }

    public BooleanType(Boolean value) {
        this.value = value;
    }

    protected BooleanType(String text) {
        if (text == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.value = "true".equals(text = text.trim()) || "1".equals(text);
    }

    protected BooleanType() {
    }

    protected void setTEXT(Boolean text) {
        this.value = text;
    }

    @Override
    protected Boolean getTEXT() {
        return this.value;
    }

    @Override
    protected QName _getName() {
        return null;
    }

    @Override
    protected void parse(Element element) throws UnmarshalException, ValidationException {
        String value = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeValue() == null) continue;
            value = value + nodeList.item(i).getNodeValue().trim();
        }
        if (value.length() == 0) {
            return;
        }
        this.value = this.value = Boolean.valueOf("true".equals(value) || "1".equals(value));
    }

    @Override
    protected Element marshal() throws MarshalException, ValidationException {
        Element root = BooleanType.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    @Override
    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Document document = parent.getOwnerDocument();
        Element element = super.marshal(parent, name, typeName);
        element.appendChild(document.createTextNode(this.toString()));
        return element;
    }

    @Override
    protected Attr marshalAttr(String name, Element parent) {
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(this.toString());
        return attr;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanType)) {
            return false;
        }
        return this.value.equals(((BooleanType)obj).value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this._getPattern() == null) {
            return String.valueOf(this.value);
        }
        for (String pattern : this._getPattern()) {
            String[] ret = valueMap.get(this.value);
            for (int i = 0; i < ret.length; ++i) {
                if (!ret[i].matches(pattern)) continue;
                return ret[i];
            }
        }
        throw new IllegalBindingException("No valid return type. Schema error!!!");
    }

    static {
        valueMap.put(true, new String[]{"true", "1"});
        valueMap.put(false, new String[]{"false", "0"});
    }
}

