/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.BindingType;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.SimpleType;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.XSType;
import org.safris.xml.bind.runtime.types.lang.DateTime;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateTimeType<T extends BindingType>
extends XSType<SimpleType>
implements Cloneable,
Serializable {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private DateTime value = null;

    protected static DateTimeType parse(String value) {
        return new DateTimeType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    protected static DateTimeType parse(DateTime value) {
        return new DateTimeType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    private static DateTime parseDateTime(String string) {
        try {
            return new DateTime(dateFormat.parse(string).getTime());
        }
        catch (ParseException e) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            illegalArgumentException.setStackTrace(e.getStackTrace());
            throw illegalArgumentException;
        }
    }

    public DateTimeType(DateTimeType binding) {
        super(binding);
        if (binding == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.value = binding.value;
    }

    public DateTimeType(DateTime value) {
        this.value = value;
    }

    public DateTimeType(String value) {
        super(value);
        if (value == null || value.length() == 0) {
            return;
        }
        this.value = DateTimeType.parseDateTime(value);
    }

    protected DateTimeType() {
    }

    @Override
    protected DateTime getTEXT() {
        return this.value;
    }

    @Override
    protected void parse(Element element) throws UnmarshalException, ValidationException {
        String value = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeValue() == null) continue;
            value = value + nodeList.item(i).getNodeValue().trim();
        }
        if (value.length() == 0) {
            return;
        }
        this.value = DateTimeType.parseDateTime(value);
    }

    @Override
    protected Element marshal() throws MarshalException, ValidationException {
        Element root = DateTimeType.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    @Override
    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Document document = parent.getOwnerDocument();
        Element element = super.marshal(parent, name, typeName);
        element.appendChild(document.createTextNode(this.toString()));
        return element;
    }

    @Override
    protected Attr marshalAttr(String name, Element parent) {
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(this.toString());
        return attr;
    }

    @Override
    public DateTimeType clone() {
        return new DateTimeType(this){

            protected QName _getName() {
                return DateTimeType._getName(DateTimeType.this);
            }
        };
    }

    @Override
    public int hashCode() {
        return this.value.toString().hashCode();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        return dateFormat.format(this.value);
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

