/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.BindingType;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.SimpleType;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.XSType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateType<T extends BindingType>
extends XSType<SimpleType> {
    private Date text = null;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    protected static DateType parse(String value) {
        return new DateType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    protected static DateType parse(Date value) {
        return new DateType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    @Override
    protected Date getTEXT() {
        return this.text;
    }

    protected void setTEXT(Date text) {
        this.text = text;
    }

    @Override
    protected void parse(Element element) throws UnmarshalException, ValidationException {
    }

    private static long parseString(String s) {
        try {
            return dateFormat.parse(s).getTime();
        }
        catch (ParseException e) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(e);
            throw illegalArgumentException;
        }
    }

    public DateType(DateType binding) {
        this.text = binding.text;
    }

    public DateType(Date binding) {
        this.text = binding;
    }

    protected DateType() {
    }

    protected DateType(long date) {
    }

    protected DateType(int year, int month, int date) {
    }

    protected DateType(int year, int month, int date, int hrs, int min) {
    }

    protected DateType(int year, int month, int date, int hrs, int min, int sec) {
    }

    protected DateType(String s) {
        this.setTime(DateType.parseString(s));
    }

    @Override
    public DateType clone() {
        return (DateType)super.clone();
    }

    public void setTime(long time) {
    }

    public String toGMTString() {
        return dateFormat.format(this);
    }

    public String toLocaleString() {
        return dateFormat.format(this);
    }

    @Override
    public String toString() {
        return dateFormat.format(this);
    }

    @Override
    protected Element marshal() throws MarshalException, ValidationException {
        Element root = DateType.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    @Override
    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Document document = parent.getOwnerDocument();
        Element element = super.marshal(parent, name, typeName);
        element.appendChild(document.createTextNode(this.toString()));
        return element;
    }

    @Override
    protected Attr marshalAttr(String name, Element parent) {
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(this.toString());
        return attr;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

