/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types;

import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.BindingType;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.SimpleType;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.XSType;
import org.safris.xml.bind.runtime.types.lang.Duration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DurationType<T extends BindingType>
extends XSType<SimpleType> {
    private Duration value = null;

    protected static DurationType parse(String value) {
        return new DurationType(DurationType.parseDuration(value)){

            protected QName _getName() {
                return null;
            }
        };
    }

    protected static DurationType parse(Duration value) {
        return new DurationType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Duration parseDuration(String string) {
        boolean isNegative;
        if (string == null) {
            throw new NullPointerException("The duration value must not be null.");
        }
        int len = string.length();
        int offset = 0;
        if (len <= 0) throw new IllegalArgumentException("Invalid duration: Empty string");
        char c = string.charAt(0);
        if (c == '-') {
            isNegative = true;
            ++offset;
        } else if (c == '+') {
            isNegative = false;
            ++offset;
        } else {
            isNegative = false;
        }
        if (len == 0 || string.charAt(offset) != 'P') {
            throw new IllegalArgumentException("Invalid duration: " + string + " (must start with P, +P, or -P)");
        }
        ++offset;
        int years = -1;
        int months = -1;
        int daysOfMonth = -1;
        int hours = -1;
        int minutes = -1;
        int seconds = -1;
        int preDecimalPoint = -1;
        boolean separatorSeen = false;
        StringBuffer digits = new StringBuffer();
        while (offset < len) {
            char c2 = string.charAt(offset);
            if (Character.isDigit(c2)) {
                digits.append(c2);
            } else if (c2 == 'T') {
                if (separatorSeen) {
                    throw new IllegalArgumentException("Invalid duration: " + string + " (date/time separator 'T' used twice)");
                }
                separatorSeen = true;
            } else {
                int l;
                if (digits.length() == 0) {
                    l = 0;
                } else {
                    try {
                        l = Integer.parseInt(digits.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid duration: " + string + " (max long value exceeded by " + digits + ")");
                    }
                    digits.setLength(0);
                }
                if (preDecimalPoint >= 0) {
                    if (c2 != 'S') throw new IllegalArgumentException("Invalid duration: " + string + " (decimal point not allowed here: " + preDecimalPoint + "." + digits + c2 + ")");
                    if (!separatorSeen) {
                        throw new IllegalArgumentException("Invalid duration: " + string + "(seconds specified before date/time separator 'T' seen)");
                    }
                    if (seconds != -1) {
                        throw new IllegalArgumentException("Invalid duration: " + string + " (seconds specified twice)");
                    }
                    seconds = preDecimalPoint;
                    preDecimalPoint = -1;
                } else {
                    if (l > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Invalid duration: " + string + " (max integer value exceeded by " + digits + ")");
                    }
                    int i = l;
                    if (c2 == '.') {
                        preDecimalPoint = i;
                    } else if (separatorSeen) {
                        if (c2 == 'Y' || c2 == 'D') {
                            throw new IllegalArgumentException("Invalid duration: " + string + " (years or days of month specified after date/time separator 'T' seen)");
                        }
                        if (c2 == 'S') {
                            if (seconds != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (seconds specified twice)");
                            }
                            seconds = i;
                        } else if (c2 == 'M') {
                            if (minutes != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (minutes specified twice)");
                            }
                            if (seconds != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (minutes specified after seconds)");
                            }
                            minutes = i;
                        } else if (c2 == 'H') {
                            if (hours != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (hours specified twice)");
                            }
                            if (minutes != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (hours specified after minutes)");
                            }
                            if (seconds != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (seconds specified after minutes)");
                            }
                            hours = i;
                        }
                    } else {
                        if (c2 == 'H' || c2 == 'S') {
                            throw new IllegalArgumentException("Invalid duration: " + string + " (hours or seconds specified before date/time separator 'T' seen)");
                        }
                        if (c2 == 'Y') {
                            if (years != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (years specified twice)");
                            }
                            if (months != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (years specified after months)");
                            }
                            if (daysOfMonth != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (years specified after days of month)");
                            }
                            years = i;
                        } else if (c2 == 'M') {
                            if (months != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (months specified twice)");
                            }
                            if (daysOfMonth != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (days of month specified after months)");
                            }
                            months = i;
                        } else if (c2 == 'D') {
                            if (daysOfMonth != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + string + " (days of month specified twice)");
                            }
                            daysOfMonth = i;
                        }
                    }
                }
            }
            ++offset;
        }
        return new Duration(isNegative, years == -1 ? 0 : years, months == -1 ? 0 : months, daysOfMonth == -1 ? 0 : daysOfMonth, hours == -1 ? 0 : hours, minutes == -1 ? 0 : minutes, seconds == -1 ? 0 : seconds);
    }

    public DurationType(DurationType binding) {
        this.value = binding.value;
    }

    public DurationType(Duration value) {
        this.value = value;
    }

    protected DurationType(String value) {
        this.value = DurationType.parseDuration(value);
    }

    protected DurationType() {
    }

    @Override
    protected Duration getTEXT() {
        return this.value;
    }

    protected void setTEXT(Duration text) {
        this.value = text;
    }

    @Override
    protected void parse(Element element) throws UnmarshalException, ValidationException {
        String value = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeValue() == null) continue;
            value = value + nodeList.item(i).getNodeValue().trim();
        }
        if (value.length() == 0) {
            return;
        }
        this.value = DurationType.parseDuration(value);
    }

    @Override
    protected Element marshal() throws MarshalException, ValidationException {
        Element root = DurationType.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    @Override
    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Document document = parent.getOwnerDocument();
        Element element = super.marshal(parent, name, typeName);
        element.appendChild(document.createTextNode(this.toString()));
        return element;
    }

    @Override
    protected Attr marshalAttr(String name, Element parent) {
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(this.toString());
        return attr;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }
}

