/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types;

import java.io.ByteArrayOutputStream;
import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.BindingType;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.SimpleType;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.XSType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HexBinaryType<T extends BindingType>
extends XSType<SimpleType> {
    private static final int[] hexToDec = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private byte[] decoded = null;
    private String encoded = null;

    protected static HexBinaryType parse(String value) {
        return new HexBinaryType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    protected static HexBinaryType parse(byte[] value) {
        return new HexBinaryType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    public HexBinaryType(HexBinaryType binding) {
        super(binding);
        if (binding == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.decoded = binding.decoded;
        this.encoded = binding.encoded;
    }

    public HexBinaryType(byte[] value) {
        this.decoded = value;
        this.encoded = HexBinaryType.encode(value);
    }

    protected HexBinaryType(String value) {
        super(value);
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.decoded = HexBinaryType.decode(value);
    }

    protected HexBinaryType() {
    }

    private static byte[] decode(String digits) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < digits.length(); i += 2) {
            char c1 = digits.charAt(i);
            if (i + 1 >= digits.length()) {
                throw new IllegalArgumentException();
            }
            char c2 = digits.charAt(i + 1);
            int b = 0;
            if (c1 >= '0' && c1 <= '9') {
                b = (byte)(b + (c1 - 48) * 16);
            } else if (c1 >= 'a' && c1 <= 'f') {
                b = (byte)(b + (c1 - 97 + 10) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                b = (byte)(b + (c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException("bad characted in hex string");
            }
            if (c2 >= '0' && c2 <= '9') {
                b = (byte)(b + (c2 - 48));
            } else if (c2 >= 'a' && c2 <= 'f') {
                b = (byte)(b + (c2 - 97 + 10));
            } else if (c2 >= 'A' && c2 <= 'F') {
                b = (byte)(b + (c2 - 65 + 10));
            } else {
                throw new IllegalArgumentException("bad characted in hex string");
            }
            out.write(b);
        }
        return out.toByteArray();
    }

    private static String encode(byte[] bytes) {
        StringBuffer buffer = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append(HexBinaryType.convertDigit(bytes[i] >> 4));
            buffer.append(HexBinaryType.convertDigit(bytes[i] & 0xF));
        }
        return buffer.toString();
    }

    private static char convertDigit(int value) {
        if ((value &= 0xF) >= 10) {
            return (char)(value - 10 + 97);
        }
        return (char)(value + 48);
    }

    protected byte[] getTEXT() {
        return this.decoded;
    }

    protected void setTEXT(byte[] text) {
        this.decoded = text;
    }

    @Override
    protected void parse(Element element) throws UnmarshalException, ValidationException {
    }

    @Override
    protected Element marshal() throws MarshalException, ValidationException {
        Element root = HexBinaryType.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    @Override
    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Document document = parent.getOwnerDocument();
        Element element = super.marshal(parent, name, typeName);
        element.appendChild(document.createTextNode(this.toString()));
        return element;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HexBinaryType)) {
            return false;
        }
        return this.encoded.equals(((HexBinaryType)obj).encoded);
    }

    @Override
    public int hashCode() {
        return this.encoded.hashCode();
    }

    @Override
    public String toString() {
        if (this.encoded == null) {
            return "";
        }
        return this.encoded.toString();
    }

    @Override
    protected Attr marshalAttr(String name, Element parent) {
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(this.toString());
        return attr;
    }
}

