/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types;

import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.BindingType;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.SimpleType;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.XSType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntegerType<T extends BindingType>
extends XSType<SimpleType> {
    private Integer value = null;

    protected static IntegerType parse(String value) {
        return new IntegerType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    protected static IntegerType parse(Integer value) {
        return new IntegerType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    public IntegerType(IntegerType binding) {
        super(binding);
        this.value = binding.value;
    }

    public IntegerType(Integer value) {
        this.value = value;
    }

    protected IntegerType(String value) {
        super(value);
        this.value = Integer.parseInt(value);
    }

    protected IntegerType() {
    }

    @Override
    protected Integer getTEXT() {
        return this.value;
    }

    protected void setTEXT(Integer value) {
        this.value = (int)value;
    }

    @Override
    protected void parse(Element element) throws UnmarshalException, ValidationException {
        String value = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeValue() == null) continue;
            value = value + nodeList.item(i).getNodeValue().trim();
        }
        if (value.length() == 0) {
            return;
        }
        this.value = Integer.parseInt(value);
    }

    @Override
    protected Element marshal() throws MarshalException, ValidationException {
        Element root = IntegerType.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    @Override
    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Document document = parent.getOwnerDocument();
        Element element = super.marshal(parent, name, typeName);
        element.appendChild(document.createTextNode(String.valueOf(this.value)));
        return element;
    }

    @Override
    protected Attr marshalAttr(String name, Element parent) {
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(this.toString());
        return attr;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntegerType)) {
            return false;
        }
        IntegerType integer = (IntegerType)obj;
        return this.value == null && integer.value == null || this.value.equals(integer.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        return String.valueOf(this.value);
    }
}

