/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types;

import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.BindingType;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.SimpleType;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.XMLChar;
import org.safris.xml.bind.runtime.types.XSType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NameType<T extends BindingType>
extends XSType<SimpleType> {
    private String value = null;

    protected static NameType parse(String value) {
        return new NameType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    protected static boolean isValid(String value) {
        boolean valid = true;
        for (int i = 0; valid && i < value.length(); ++i) {
            valid = i == 0 ? XMLChar.isNameStart(value.charAt(i)) : XMLChar.isName(value.charAt(i));
        }
        return valid;
    }

    public NameType(NameType binding) {
        super(binding);
        if (binding == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.value = binding.value;
    }

    public NameType(String value) {
        super(value);
        if (!NameType.isValid(value)) {
            throw new IllegalArgumentException("value is invalid for relevant type");
        }
        this.value = value;
    }

    protected NameType() {
    }

    @Override
    protected String getTEXT() {
        return this.value;
    }

    protected void setTEXT(String value) {
        this.value = value;
    }

    @Override
    protected void parse(Element element) throws UnmarshalException, ValidationException {
        String value = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeValue() == null) continue;
            value = value + nodeList.item(i).getNodeValue().trim();
        }
        if (value.length() == 0) {
            return;
        }
        this.value = value;
    }

    @Override
    protected Element marshal() throws MarshalException, ValidationException {
        Element root = NameType.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    @Override
    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Document document = parent.getOwnerDocument();
        Element element = super.marshal(parent, name, typeName);
        element.appendChild(document.createTextNode(this.toString()));
        return element;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NameType)) {
            return false;
        }
        return this.value.equals(((NameType)obj).value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    @Override
    protected Attr marshalAttr(String name, Element parent) {
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(this.toString());
        return attr;
    }
}

