/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types;

import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.StringType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class NormalizedStringType
extends StringType {
    private String value = null;

    protected static NormalizedStringType parse(String value) {
        return new NormalizedStringType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    protected static boolean isValid(String value) {
        for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    return false;
                }
            }
        }
        return true;
    }

    public NormalizedStringType(NormalizedStringType binding) {
        super(binding);
        if (this.value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.value = binding.value;
    }

    public NormalizedStringType(String value) {
        super(value);
        if (!NormalizedStringType.isValid(value)) {
            throw new IllegalArgumentException("value is invalid for relevant type");
        }
        this.value = value;
    }

    protected NormalizedStringType() {
    }

    protected String getTEXT() {
        return this.value;
    }

    protected void setTEXT(String value) {
        this.value = value;
    }

    protected QName _getName() {
        return null;
    }

    protected void parse(Element element) throws UnmarshalException, ValidationException {
    }

    protected Element marshal() throws MarshalException, ValidationException {
        Element root = NormalizedStringType.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Document document = parent.getOwnerDocument();
        Element element = super.marshal(parent, name, typeName);
        element.appendChild(document.createTextNode(this.toString()));
        return element;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NormalizedStringType)) {
            return false;
        }
        return this.value.equals(((NormalizedStringType)obj).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    protected Attr marshalAttr(String name, Element parent) {
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(this.toString());
        return attr;
    }
}

